% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdi_functions.R
\name{convertRDI}
\alias{convertRDI}
\title{Convert RDI measures}
\usage{
convertRDI(d, models = NULL, calcSD = FALSE)
}
\arguments{
\item{d}{Distance matrix (as produced by \link{calcRDI}), or a vector of 
distances.}

\item{models}{Set of RDI models, as produced by \link{rdiModel}. If \code{NULL},
RDI models will be calculated based on the attributes in the distance
matrix.}

\item{calcSD}{logical; if \code{TRUE}, standard deviations for each estimate will be returned.}
}
\value{
A list containing either one or two features:

\tabular{rl}{
  \emph{pred}  \tab The converted predictions; same length as \code{d}. \cr
  \emph{sd}  \tab If \code{calcSD==T}, a set of standard deviation estimates for each
               prediction. 
}
}
\description{
Method to convert RDI values to fold/percent change
}
\details{
The convertRDI function works by first generating a model for the RDI values at a given
repertoire size and feature count using the \link{rdiModel} function (see that 
method's help file for more details). The RDI models predict the average 
log-fold/percent change across a range of RDI values, and allows us to convert RDI to
a more stable and interpretable metric.  

In addition to the average log-fold or percent change value, \link{rdiModel} 
also generates models for the standard deviation at each RDI value. This is useful for
understanding the confidence intervals around the fold change estimate.
}
\examples{

#create genes
genes = sample(letters, 10000, replace=TRUE)
#create sequence annotations
seqAnnot = data.frame(donor = sample(1:4, 10000, replace=TRUE))
#calculate RDI
d = rdi(genes, seqAnnot)

##convert RDI to actual 'lfc' estimates and compare
dtrue = convertRDI(d)$pred
plot(d, dtrue)

##look at SD ranges around lfc estimates
dtrue = convertRDI(d, calcSD=TRUE)

##plot using ggplot2
library(ggplot2)
x = as.numeric(d)
y = as.numeric(dtrue$pred)
sd = as.numeric(dtrue$sd)
qplot(x,y)+geom_errorbar(aes(x=x, ymin=y-sd, ymax=y+sd))

}
