% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contains.R
\name{re_contains}
\alias{re_contains}
\title{Check if string contains a regular expression}
\usage{
re_contains(pattern, string, ...)
}
\arguments{
\item{pattern}{A regular expression pattern or a compiled pattern object.}

\item{string}{A character vector where each element is a string to be checked against the pattern.}

\item{...}{
  Arguments passed on to \code{\link[=re_compile]{re_compile}}
  \describe{
    \item{\code{IGNORECASE}}{Flag to indicate case-insensitive matching.}
    \item{\code{I}}{Abbreviation for IGNORECASE.}
    \item{\code{MULTILINE}}{Flag to indicate multi-line matching, where \code{^} and \code{$} match the start and end of each line.}
    \item{\code{M}}{Abbreviation for MULTILINE.}
    \item{\code{DOTALL}}{Flag to indicate that \code{.} (dot) should match any character including newline.}
    \item{\code{S}}{Abbreviation for DOTALL}
    \item{\code{VERBOSE}}{Flag to allow a more verbose regex syntax, which can include comments and whitespace for readability.}
    \item{\code{X}}{Abbreviation for VERBOSE}
    \item{\code{NOFLAG}}{Flag to indicate that no flags should be set.}
  }}
}
\value{
A logical vector of the same length as \code{string}, indicating whether each element contains a match for the
pattern.
}
\description{
\code{re_contains} checks whether a specified pattern (regular expression) is found within each element of a
character vector. If the provided pattern is not already a compiled pattern object, it compiles it using
\code{re_compile}.
}
\examples{
pattern <- re_compile("^abc", IGNORECASE)
re_contains(pattern, "Abcdef")
re_contains("xyz$", "hello world xyz")
}
