% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readtextgrid.R, R/legacy.R
\name{read_textgrid}
\alias{read_textgrid}
\alias{read_textgrid_lines}
\alias{legacy_read_textgrid}
\alias{legacy_read_textgrid_lines}
\title{Read a textgrid file into a tibble}
\usage{
read_textgrid(path, file = NULL, encoding = NULL)

read_textgrid_lines(lines, file = NULL)

legacy_read_textgrid(path, file = NULL, encoding = NULL)

legacy_read_textgrid_lines(lines, file = NULL)
}
\arguments{
\item{path}{a path to a textgrid}

\item{file}{an optional value to use for the \code{file} column. For
\code{read_textgrid()}, the default is the base filename of the input file. For
\code{read_textgrid_lines()}, the default is \code{NA}.}

\item{encoding}{the encoding of the textgrid. The default value \code{NULL} uses
\code{\link[readr:encoding]{readr::guess_encoding()}} to guess the encoding of the textgrid. If an
encoding is provided, it is forwarded to \verb{[readr::locale()]} and
\verb{[readr::read_lines()]}.}

\item{lines}{alternatively, the lines of a textgrid file}
}
\value{
a tibble with one row per textgrid annotation
}
\description{
Read a textgrid file into a tibble
}
\details{
The \code{legacy_read_textgrid} functions are the original textgrid
parsers provided by the package. They assume that the TextGrid file is a
"long" format textgrid; this is the default format used by "Save a text
file..." in Praat.

The current \code{read_textgrid()} functions are more
flexible and can read in "short" format textgrids and textgrids with
comments.

See \url{https://www.fon.hum.uva.nl/praat/manual/TextGrid_file_formats.html}
for a description of the textgrid file format. Note that this package does
not strictly adhere to format as described in this document. For example,
the document says that numbers should be freestanding (surrounded by spaces
or string boundaries), but Praat.exe can handle malformed numbers like
\verb{100ms}. Therefore, we tried to implement a parser that matched what Praat
actually handles.
}
\examples{
tg <- system.file("Mary_John_bell.TextGrid", package = "readtextgrid")
read_textgrid(tg)
}
