% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_functions.R
\name{project_mec}
\alias{project_mec}
\title{Find the projected Maximum Observed Effluent Concentration (MEC)}
\usage{
project_mec(
  qual,
  result,
  nd = c("<", "nd", "ND"),
  percentile = 0.95,
  conf_level = 0.99,
  nd_adjustment = 0.5,
  simple_output = FALSE
)
}
\arguments{
\item{qual}{A character vector containing non-detect indicator strings, e.g., "<" or "ND". The strings used to indicate censored status can be edited in the "nd" argument.}

\item{result}{A numeric vector of concentration measurements.}

\item{nd}{A list indicating all the censoring flags included in the dataset. Defaults to "<", "nd", and "ND".}

\item{percentile}{Location on lognormal distribution to estimate the projected MEC.}

\item{conf_level}{Confidence level of projected estimate.}

\item{nd_adjustment}{Adjustment factor for non-dectect values. Non-detect values (as indicated in qual vector) are multiplied by nd_adjustment factor; i.e. result * nd_adjustment. Typically, method detection limits or reporting limits are used as result values for non-detects.}

\item{simple_output}{Logical value. If TRUE, the output columns are concatenated into a single character string (e.g., "<0.2") which can be useful for constructing summary tables.}
}
\value{
Dataframe with a qualifier column (character) and a MEC column (numeric).
}
\description{
Find the MEC projected from a lognormal distribution using methods described in EPA's Technical Support Document for Water Quality-based Toxics Control.
}
\examples{
# Find observed MEC
cen_result <- c(rep("", 10), rep("<", 10))
result     <- 1:20
project_mec(cen_result, result)

# Demonstrate simplified output
cen_result <- rep("<", 20)
project_mec(cen_result, result, simple_output = TRUE)

# Define a set of custom non-detect flags
cen_result <- c(rep("non-detect", 5), rep("<", 10), rep("mdl", 5))
project_mec(cen_result, result, nd = c("non-detect", "<", "mdl"))

# Change the substitution multiplier used for non-detect values
cen_result <- c(rep("<", 5), rep("", 15))
result     <- c(101:120)
project_mec(cen_result, result)   # Use default 0.5 multiplier

# Use 1.0 multiplier (equivalent to using MDL)
project_mec(cen_result, result, nd_adjustment = 1.0)

# Use 0.0 multiplier (equivalent to zero substitution)  
project_mec(cen_result, result, nd_adjustment = 0)  

}
