% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recolorize_to_png.R
\name{recolorize_to_png}
\alias{recolorize_to_png}
\title{Save a recolored image as a PNG}
\usage{
recolorize_to_png(recolorize_obj, filename = "")
}
\arguments{
\item{recolorize_obj}{A recolorize object.}

\item{filename}{Filename for saving the PNG.}
}
\value{
No return value; saves a PNG file to the specified location.
}
\description{
Saves a recolored image from a recolorize object to a PNG. This is
done by calling \link{recoloredImage} and \link[png:writePNG]{png::writePNG}.
}
\details{
This function saves a png with the same dimensions (in pixels) as the
image that was originally provided to recolorize (meaning if you resized your original
image, the resulting PNG will also be smaller). Anything more complicated can be
created with custom scripts: for example, you could create a vector image using
\link{recolorizeVector}, and then save this as a PNG of any resolution/size.
}
\examples{
\donttest{
img <- system.file("extdata/corbetti.png", package = "recolorize")
rc <- recolorize2(img, cutoff = 45)

# save a PNG:
recolorize_to_png(rc, "corbetti_recolored.png")

# remove the PNG (so this example doesn't spam your working directory)
file.remove("corbetti_recolored.png")
}

}
