% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distances.R
\name{dist_ham}
\alias{dist_ham}
\title{Calculate Hamming Distances}
\usage{
dist_ham(plans, ncores = 1)
}
\arguments{
\item{plans}{A \code{redist_plans} object or plans_matrix where each row indicates a district assignment and each column is a plan.}

\item{ncores}{Integer number of cores to use. Default is 1.}
}
\value{
matrix of plan distances
}
\description{
Calculate Hamming Distances
}
\examples{
data(nh)
data(nh_m)
# For a single plan (distance is trivial, 0):
dist_ham(plans = nh$r_2020)

# Or many plans:
dist_ham(plans = nh_m[, 3:5])

}
\concept{distances}
