% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{rl_open_file}
\alias{rl_open_file}
\title{Open file for editing}
\usage{
rl_open_file(path = NULL, scope = c("user", "project"))
}
\arguments{
\item{path}{Optional character string specifying the path to the file to open.
If \code{NULL} (default), a \code{.Renviron} file is opened based on the value of \code{scope}.}

\item{scope}{Character string indicating which \code{.Renviron} file to open when \code{path = NULL}:
\itemize{
\item \code{user}: Opens the user-level \code{.Renviron}
\item \code{project}: Opens or creates a \code{.Renviron} file in the current working directory
}}
}
\value{
(Invisibly) returns the path to the file opened.
}
\description{
Opens a specified file for editing in the system's default editor (as configured by R).
}
\examples{
\dontrun{
# Open user-level .Renviron
open_file()
}

}
