% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rl_orders.R
\name{rl_orders}
\alias{rl_orders}
\title{IUCN Red List taxa by order}
\usage{
rl_orders(
  order_name = NULL,
  year_published = NULL,
  latest = NULL,
  scope_code = NULL,
  page = 1
)
}
\arguments{
\item{order_name}{Character. The order name (e.g., "Carnivora").
Use \code{\link[=rl_orders]{rl_orders()}} to list available orders.}

\item{year_published}{Optional. Single or numeric vector of years to filter assessments by publication year.}

\item{latest}{Optional. Logical. If \code{TRUE}, return only the latest assessment per species.}

\item{scope_code}{Optional. Integer One or more scope codes to filter assessments.}

\item{page}{Optional. Integer vector. Specify one or more page numbers to fetch.
If \code{NULL} or \code{NA}, all pages will be fetched automatically.}
}
\value{
A tibble (class \code{tbl_df}, \code{tbl}, \code{data.frame}) where each column represents a unique API response JSON key.
If \code{order_name = NULL}, the tibble contains available taxonomic orders with a column for order names.
If \code{order_name} is provided, the tibble contains assessment data for the specified order, including year, taxon details, criteria,
and other relevant metadata.
}
\description{
Retrieve species assessments by taxonomic order.
If \code{order_name = NULL}, it returns a list of available orders.
If \code{order_name} is provided, it retrieves assessments for species in the specified order.
}
\examples{
\dontrun{
# List all available orders
rl_orders()

# Get assessments for Carnivora order
rl_orders(order_name = "Carnivora")

# Get latest Primates assessments published in 2022
rl_orders(
  order_name = "Primates",
  year_published = 2022,
  latest = TRUE
)
}
}
