% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{tbl_redcap}
\alias{tbl_redcap}
\title{Create REDCap Data Table Reference}
\usage{
tbl_redcap(conn, table_name = NULL)
}
\arguments{
\item{conn}{A DuckDB connection object.}

\item{table_name}{Character string specifying the table name.
If NULL, uses the table name stored in connection attributes.
Default is NULL.}
}
\value{
A tbl_sql object referencing the data table with redcap_table attribute.
}
\description{
Creates a tbl reference to the main REDCap data table in the database.
The original table name is stored as an attribute to preserve context
through dplyr operations (limited to filter, select, arrange, and group_by).
Uses the data table name stored in the connection attributes if available.
}
\examples{
\dontrun{
data <- tbl_redcap(conn)
}

}
