% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trivRegr.R
\name{trivRegr}
\alias{trivRegr}
\title{Trivariate regression model}
\usage{
trivRegr(f = f, data = data)
}
\arguments{
\item{f}{A list of 9 formulas defining the covariates effects
in three responses means, in their variances, and in their correlations. The formulas
follow the mgcv::gam() structure.}

\item{data}{A data frame containing the reponses, and predictor variables values.}
}
\value{
This function returns the covariates effect on the means,
variances, and correlation for a trivariate response variable.
}
\description{
This function estimates the covariates effects on the means vector,
and variance covariance matrix of a trivariate variable. Non linear effects
might be estimated for continuous covariates using penalized splines.
}
\examples{
dm_no <- subset(aegis, aegis$dm == "no")

# Model formulas
mu1 <- fpg ~ s(age)
mu2 <- hba1c ~ s(age)
mu3 <- fru~s(age)
var1 <- ~ s(age)
var2 <- ~ s(age)
var3 <- ~ s(age)
theta12 <- ~ s(age)
theta13 <- ~ s(age)
theta23 <- ~ s(age)
f <- list(mu1, mu2, mu3, var1, var2, var3, theta12, theta13, theta23)

# Model fit
fit <- trivRegr(f, data = dm_no)
# Trivariate region estimation
region <- trivRegion(fit, tau = 0.95)
plot(region, col = 2, planes = TRUE)
plot(region,
  cond = TRUE, newdata = data.frame(age = c(20, 80)),
  xlab = "FPG, mg/dl", ylab = "HbA1c, \%", zlab = "Fru, mg/dL"
)

}
