% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refreshr.r
\name{is.refreshr}
\alias{is.refreshr}
\title{Analysing refreshr objects}
\usage{
is.refreshr(df)
}
\arguments{
\item{df}{Dataframe/table to be checked.}
}
\value{
\code{TRUE} if the dataframe/table is of class \code{refreshr} (i.e.
  is of class "refreshr"), \code{FALSE} otherweise.
}
\description{
Checks if a dataframe/table is refreshable.
}
\examples{
\dontrun{

library(data.table)
library(dplyr)

# Load US unemployment rate from Bureau of Labor Statistics
data <- fread("https://download.bls.gov/pub/time.series/ln/ln.data.1.AllData", sep="\t")

# Make refreshable and specify code for data preparation (filter raw data for
# the overall US employment rate) with # being a placeholder for the downloaded
# raw data
data_refresh <- make_refreshable(data,
                     load_code = "data.table::fread(
                        \"https://download.bls.gov/pub/time.series/ln/ln.data.1.AllData\",
                        sep=\"\t\")",
                     prep_code = "filter(#, series_id==\"LNS14000000\")")

# Save refreshable dataframe as RData file (e.g. to share dataset with coworkers or public)
save(data_refresh, file = "refresh.RData")

# Remove dataframe and reload it from file
rm(data_refresh)
load(file = "refresh.RData")

# Refresh the dataframe
data_refresh <- refresh(data_refresh)

# Show properties of refreshable dataframe
properties(data_refresh)

# Check if refreshable dataframe is up-to-date with the remote data source
uptodate(data_refresh)
}
}
