% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refreshr.r
\name{make_refreshable}
\alias{make_refreshable}
\title{Making dataframes/tables refreshable}
\usage{
make_refreshable(df, load_code, prep_code = NULL)
}
\arguments{
\item{df}{The dataframe/table that is to be made refreshable}

\item{load_code}{The code used to load the data from the data source. Please
not that quotes need to be escaped (code{\"}).}

\item{prep_code}{The code used to transform the raw data downloaded from the
data source. The placeholder \code{#} can be used in this code to refer to
the data downloaded from the data source.}
}
\value{
A dataframe/table of class \code{refreshr} that can be refreshed by
  calling \code{refresh()}.
}
\description{
Makes a dataframe/table refreshable, i.e. connects it with a
  data source and specifies code that is applied to the raw data after the
  data has been loaded (optional).
}
\examples{
\dontrun{

library(data.table)
library(dplyr)

# Load US unemployment rate from Bureau of Labor Statistics
data <- fread("https://download.bls.gov/pub/time.series/ln/ln.data.1.AllData", sep="\t")

# Make refreshable and specify code for data preparation (filter raw data for
# the overall US employment rate) with # being a placeholder for the downloaded
# raw data
data_refresh <- make_refreshable(data,
                     load_code = "data.table::fread(
                        \"https://download.bls.gov/pub/time.series/ln/ln.data.1.AllData\",
                        sep=\"\t\")",
                     prep_code = "filter(#, series_id==\"LNS14000000\")")

# Save refreshable dataframe as RData file (e.g. to share dataset with coworkers or public)
save(data_refresh, file = "refresh.RData")

# Remove dataframe and reload it from file
rm(data_refresh)
load(file = "refresh.RData")

# Refresh the dataframe
data_refresh <- refresh(data_refresh)

# Show properties of refreshable dataframe
properties(data_refresh)

# Check if refreshable dataframe is up-to-date with the remote data source
uptodate(data_refresh)
}
}
