% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refreshr.r
\name{uptodate}
\alias{uptodate}
\title{Updating dataframes/tables}
\usage{
uptodate(df)
}
\arguments{
\item{df}{Dataframe/table to be checked.}
}
\value{
\code{TRUE} if if the dataframe/table properly reflects the state of
  its data source, \code{FALSE} otherweise.
}
\description{
Checks if a refreshable dataframe/table is up-to-date with its
  data source.
}
\details{
Please note then \code{updtodate()} needs to dowload the data from
  the data source and process it according to the data preparation steps
  defined in the \code{prep} property of the refreshable dataframe/table in
  order to compare it to the current data of the refreshable dataframe/table.
  Depending on the amount of data and the complexity of the preparation steps
  this may take some time.
}
\examples{
\dontrun{

library(data.table)
library(dplyr)

# Load US unemployment rate from Bureau of Labor Statistics
data <- fread("https://download.bls.gov/pub/time.series/ln/ln.data.1.AllData", sep="\t")

# Make refreshable and specify code for data preparation (filter raw data for
# the overall US employment rate) with # being a placeholder for the downloaded
# raw data
data_refresh <- make_refreshable(data,
                     load_code = "data.table::fread(
                        \"https://download.bls.gov/pub/time.series/ln/ln.data.1.AllData\",
                        sep=\"\t\")",
                     prep_code = "filter(#, series_id==\"LNS14000000\")")

# Save refreshable dataframe as RData file (e.g. to share dataset with coworkers or public)
save(data_refresh, file = "refresh.RData")

# Remove dataframe and reload it from file
rm(data_refresh)
load(file = "refresh.RData")

# Refresh the dataframe
data_refresh <- refresh(data_refresh)

# Show properties of refreshable dataframe
properties(data_refresh)

# Check if refreshable dataframe is up-to-date with the remote data source
uptodate(data_refresh)
}
}
