% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derivatives.r
\name{d_impact_block}
\alias{d_impact_block}
\title{Partial derivatives for mean and variance impact equation.}
\usage{
d_impact_block(
  p_mean,
  p_var,
  etable,
  theta,
  mean_predictors,
  var_predictors,
  samp_size,
  num_items,
  num_quad,
  num_predictors
)
}
\arguments{
\item{p_mean}{Vector of mean impact parameters.}

\item{p_var}{Vector of variance impact parameters.}

\item{etable}{E-table for impact.}

\item{theta}{Matrix of adaptive theta values.}

\item{mean_predictors}{Possibly different matrix of predictors for the mean
impact equation.}

\item{var_predictors}{Possibly different matrix of predictors for the
variance impact equation.}

\item{samp_size}{Sample size in data set.}

\item{num_items}{Number of items in data set.}

\item{num_quad}{Number of quadrature points used for approximating the
latent variable.}

\item{num_predictors}{Number of predictors in dataset.}
}
\value{
a \code{"list"} of first and second partial derivatives for impact equation (to use
with multivariate Newton-Raphson)
}
\description{
Partial derivatives for mean and variance impact equation.
}
\keyword{internal}
