% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rfun_rga2h.R
\name{ga2h}
\alias{ga2h}
\title{Graphical approach for two hypotheses}
\usage{
ga2h(w, G, p, alpha)
}
\arguments{
\item{w}{a vector of initial weights}

\item{G}{a matrix of initial transaction weights}

\item{p}{a vector of p-values}

\item{alpha}{a number of significance level}
}
\value{
a logical vector indicating whether the hypothesis is rejected: TRUE = rejected, FALSE = accepted
}
\description{
Graphical approach for two hypotheses
}
\examples{
w <- c(0.3,0.7)
G <- matrix(c(0,1,1,0),nrow=2,byrow=TRUE)
p <- c(0.032, 0.038)
alpha <- 0.05
ga2h(w=w,G=G,p=p, alpha=alpha)

}
\references{
Bretz, F., Maurer, W., Brannath, W., and Posch, M. (2009). A graphical approach to sequentially rejective multiple test procedures. Statistics in Medicine 28, 586–-604. <doi:10.1002/sim.3495>
}
