% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.haplen.R
\name{plot.haplen}
\alias{plot.haplen}
\title{Plot the length of extended haplotypes around a focal marker}
\usage{
\method{plot}{haplen}(
  x,
  allele = NA,
  group_by_allele = TRUE,
  order_by_length = FALSE,
  col = c("blue", "red", "violet", "orange"),
  mrk.col = "gray",
  lwd = 1,
  hap.names = NULL,
  cex.lab = 1,
  family.lab = "",
  offset.lab = 0.5,
  pos.lab = "left",
  legend = NA,
  legend.xy.coords = "automatic",
  ...
)
}
\arguments{
\item{x}{an object of class \code{haplen} generated by \code{\link{calc_haplen}}.}

\item{allele}{if \code{NA} (default), haplotypes of all alleles are plotted,
otherwise for the specified alleles. Alleles must be specified by their
internal coding, i.e. '0' for ancestral resp. major allele, etc.}

\item{group_by_allele}{logical. If \code{TRUE} (default), group chromosomes
by their allele at the focal marker; alleles are ordered by their internal coding
unless parameter \code{alleles} is specified. If \code{FALSE}, haplotypes are drawn by
their order in the input file.}

\item{order_by_length}{if \code{TRUE}, chromosomes are ordered by their
shared haplotype length.}

\item{col}{color for each allele (as coded internally).}

\item{mrk.col}{color of the vertical line at the focal marker position.}

\item{lwd}{line width.}

\item{hap.names}{a vector containing the names of chromosomes.}

\item{cex.lab}{relative letter size of labels. See \code{\link[graphics]{par}}.}

\item{family.lab}{font family for labels. See \code{\link[graphics]{par}}.}

\item{offset.lab}{offset of labels. See \code{\link[graphics]{par}}.}

\item{pos.lab}{position of haplotype labels. Either \code{"left"} , \code{"right"} or \code{"both"}.}

\item{legend}{legend text.}

\item{legend.xy.coords}{if \code{"automatic"} (default) places legend either top left or top right;
if \code{"none"}, no legend is drawn; otherwise argument is passed to \code{\link[graphics]{legend}}.}

\item{...}{other parameters to be passed to \code{\link[graphics]{plot.default}}.}
}
\description{
Plot the length of extended haplotype around a focal marker.
}
\examples{
#example haplohh object (280 haplotypes, 1424 SNPs)
#see ?haplohh_cgu_bta12 for details
data(haplohh_cgu_bta12)
#plotting length of extended haplotypes for both ancestral and derived allele
#of the marker "F1205400"
#which displays a strong signal of selection
f <- calc_furcation(haplohh_cgu_bta12, mrk = "F1205400")
h <- calc_haplen(f)
plot(h)
plot(h, hap.names = hap.names(haplohh_cgu_bta12), cex.lab = 0.3)
}
\seealso{
\code{\link{calc_haplen}}, \code{\link{plot.furcation}}.
}
