% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.rgam.R
\name{print.rgam}
\alias{print.rgam}
\title{Print a rgam object}
\usage{
\method{print}{rgam}(x, digits = max(3, getOption("digits") - 3), ...)
}
\arguments{
\item{x}{Fitted \code{rgam} object.}

\item{digits}{Significant digits in printout.}

\item{...}{Additional print arguments.}
}
\value{
The matrix above is silently returned.
}
\description{
Print a summary of the rgam path at each step along the path.
}
\details{
The call that produced the object x is printed, followed by a five-column
matrix with columns NonZero, Lin, NonLin, %Dev and Lambda. The first three
columns say how many nonzero, linear and nonlinear terms there are. %Dev is
the percent deviance explained (relative to the null deviance).
}
\examples{
set.seed(1)
n <- 100; p <- 12
x <- matrix(rnorm(n * p), n, p)
beta <- matrix(c(rep(2, 3), rep(0, 9)), ncol = 1)
y <- x \%*\% beta + x[, 4]^2 + rnorm(n)
fit <- rgam(x, y)
print(fit)

}
\seealso{
\code{\link{rgam}}.
}
