% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.rsadd.R
\name{predict.rsadd}
\alias{predict.rsadd}
\title{Subject-specific prediction for an excess hazards model}
\usage{
\method{predict}{rsadd}(object, newdata, type = "Haz", add.times, ...)
}
\arguments{
\item{object}{An rsadd object}

\item{newdata}{A data.frame with one row (add covariate values in columns)}

\item{type}{By default ('Haz') returns cumulative hazards. If 'prob' it calculates CIFs. If 'both' a list is returned with Haz and prob.}

\item{add.times}{specific times at which predictions should be obtained.}

\item{...}{Not used for now}
}
\value{
A data.frame containing the times, excess and population components.
}
\description{
A function that returns subject-specific predictions from an rsadd object.
}
\examples{
data(rdata)
fit <- rsadd(Surv(time,cens)~sex+age,rmap=list(age=age*365.241),
             ratetable=slopop,data=rdata,int=5,method="EM")
predict(fit, data.frame(sex=2,age=68, year=as.Date('1982-06-24')))
}
\author{
Damjan Manevski \email{damjan.manevski@mf.uni-lj.si}
}
