% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remind.R
\name{remind}
\alias{remind}
\alias{remind.default}
\alias{remind.function}
\alias{remind<-}
\alias{print.reminder}
\title{Insert, extract, and print "reminders" for functions and objects}
\usage{
remind(x, ...)

\method{remind}{default}(x, ...)

\method{remind}{function}(x, begin = "<<", end = ">>", ...)

remind(x) <- value

\method{print}{reminder}(x, ...)
}
\arguments{
\item{x}{An R object/function for \code{remind}; a class "reminder" object
for \code{print}}

\item{...}{Additional arguments to methods}

\item{begin}{Character string delimiting reminder beginning}

\item{end}{Character string delimiting reminder ending}

\item{value}{Character vector of text to attach as '\code{comment}' attribute}
}
\value{
A list of S3 class "reminder".
}
\description{
Insert, extract, and print text (i.e. character vector)
"reminders" either as the "comment" attribute of objects or as delimited
comments within function source code.
}
\details{
Extracts text between the 'begin' and 'end' delimiting character
strings within source code comments. This is mostly intended to enable easy
addition and retrieval of informal text notes during the course of
script/function development, aka 'reminders', e.g. to fix something, add a
validity check, note additional argument requirements etc. Multiple such
separately delimited reminders can be included.

As a slight convenience, the function wraps R's existing \code{comment}
function to attach and extract reminders as the 'comment' attribute of any R
object. These can be used to provide information (provenance, context) on
objects and even serve as a kind of minimal informal Help documentation for
functions, i.e. a sort of simple manual "tooltip" functionality.
}
\note{
Because there is no fixed syntax in source code comments, extracting
  reminders cannot be guaranteed to always work correctly. Some simple checks
  have been included to warn when they may not be properly extracted, but
  this may not succeed in all cases.

  Also, retrieving reminders from functions depends on whether
 \code{options(keep.source = TRUE)} is in use when they are saved.
}
\examples{
x <- 1:3
remind(x)
remind(x) <- c("first comment","and a second")
remind(x)
remind(x) <- NULL ## removes reminder
remind(x)
f <- function(x){
   y <- x
   ## Some miscellaneous comments
   ## Now <<This is reminder 1>> and next
   ## This is
   ## yet another <<reminder 2 is this>>
   ## some more stuff
   y
}
f(5)
remind(f)
remind(f)<- "something else"
remind(f)
## "tooltip" type example:
my.summary<- function(x, fun = mean,...)fun(x)
remind(my.summary)<-
"Don't forget to include the na.rm argument if missing values might be present"
remind(my.summary)
rm(f,x,my.summary)
}
\seealso{
\code{\link{comment}}
}
