% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/http-methods.R
\name{lemmy_get_comments}
\alias{lemmy_get_comments}
\title{Get / fetch comments.}
\usage{
lemmy_get_comments(
  type_ = NULL,
  sort = NULL,
  max_depth = NULL,
  page = NULL,
  limit = NULL,
  community_id = NULL,
  community_name = NULL,
  post_id = NULL,
  parent_id = NULL,
  saved_only = NULL,
  auth = NULL,
  .lemmy_instance = getOption("lemmy_instance", "https://lemmy.world")
)
}
\arguments{
\item{type_}{(Optional) One of "All", "Local", or "Subscribed".}

\item{sort}{(Optional) One of "Hot", "New", "Old", or "Top".}

\item{max_depth}{(Optional) A numeric value.}

\item{page}{(Optional) A numeric value.}

\item{limit}{(Optional) A numeric value.}

\item{community_id}{(Optional) A numeric value.}

\item{community_name}{(Optional) A character value.}

\item{post_id}{(Optional) A numeric value.}

\item{parent_id}{(Optional) A numeric value.}

\item{saved_only}{(Optional) A logical value.}

\item{auth}{(Optional) A character value.}

\item{.lemmy_instance}{Default: "https://lemmy.world". Change the default instance by setting the \code{lemmy_instance} \code{\link[=options]{options()}}.}
}
\value{
A \code{list} of length 1:
\preformatted{<list>
`-comments: <list>
  `-[Each element]: <list>
    |-comment: <list>
    | |-id: A numeric value
    | |-creator_id: A numeric value
    | |-post_id: A numeric value
    | |-content: A character value
    | |-removed: A logical value
    | |-published: A character value
    | |-updated: (Optional) A character value
    | |-deleted: A logical value
    | |-ap_id: A character value
    | |-local: A logical value
    | |-path: A character value
    | |-distinguished: A logical value
    | `-language_id: A numeric value
    |-creator: <list>
    | |-id: A numeric value
    | |-name: A character value
    | |-display_name: (Optional) A character value
    | |-avatar: (Optional) A character value
    | |-banned: A logical value
    | |-published: A character value
    | |-updated: (Optional) A character value
    | |-actor_id: A character value
    | |-bio: (Optional) A character value
    | |-local: A logical value
    | |-banner: (Optional) A character value
    | |-deleted: A logical value
    | |-inbox_url: A character value
    | |-matrix_user_id: (Optional) A character value
    | |-admin: A logical value
    | |-bot_account: A logical value
    | |-ban_expires: (Optional) A character value
    | `-instance_id: A numeric value
    |-post: <list>
    | |-id: A numeric value
    | |-name: A character value
    | |-url: (Optional) A character value
    | |-body: (Optional) A character value
    | |-creator_id: A numeric value
    | |-community_id: A numeric value
    | |-removed: A logical value
    | |-locked: A logical value
    | |-published: A character value
    | |-updated: (Optional) A character value
    | |-deleted: A logical value
    | |-nsfw: A logical value
    | |-embed_title: (Optional) A character value
    | |-embed_description: (Optional) A character value
    | |-thumbnail_url: (Optional) A character value
    | |-ap_id: A character value
    | |-local: A logical value
    | |-embed_video_url: (Optional) A character value
    | |-language_id: A numeric value
    | |-featured_community: A logical value
    | `-featured_local: A logical value
    |-community: <list>
    | |-id: A numeric value
    | |-name: A character value
    | |-title: A character value
    | |-description: (Optional) A character value
    | |-removed: A logical value
    | |-published: A character value
    | |-updated: (Optional) A character value
    | |-deleted: A logical value
    | |-nsfw: A logical value
    | |-actor_id: A character value
    | |-local: A logical value
    | |-icon: (Optional) A character value
    | |-banner: (Optional) A character value
    | |-followers_url: A character value
    | |-inbox_url: A character value
    | |-hidden: A logical value
    | |-posting_restricted_to_mods: A logical value
    | `-instance_id: A numeric value
    |-counts: <list>
    | |-id: A numeric value
    | |-comment_id: A numeric value
    | |-score: A numeric value
    | |-upvotes: A numeric value
    | |-downvotes: A numeric value
    | |-published: A character value
    | |-child_count: A numeric value
    | `-hot_rank: A numeric value
    |-creator_banned_from_community: A logical value
    |-subscribed: One of "Subscribed", "NotSubscri...
    |-saved: A logical value
    |-creator_blocked: A logical value
    `-my_vote: (Optional) A numeric value
}
}
\description{
\code{HTTP.GET /comment/list}
}
\examples{
\dontshow{if (remmy:::is_lemmy_world()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
comment_list <- lemmy_get_comments(limit = 1, sort = "Top")

comment_list$comments[[1]]$community$name

comment_list$comments[[1]]$post$name

comment_list$comments[[1]]$comment$content
\dontshow{\}) # examplesIf}
}
