% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{rm_survdiff}
\alias{rm_survdiff}
\title{Display event counts, expected event counts and logrank test of differences}
\usage{
rm_survdiff(
  data,
  time,
  status,
  covs,
  strata,
  includeVarNames = FALSE,
  digits = 1,
  showCols = c("N", "Observed", "Expected"),
  CIwidth = 0.95,
  conf.type = "log",
  caption = NULL,
  tableOnly = FALSE,
  fontsize
)
}
\arguments{
\item{data}{data frame containing survival data}

\item{time}{string indicating survival time variable}

\item{status}{string indicating event status variable}

\item{covs}{character vector indicating variables to group observations by}

\item{strata}{string indicating the variable to stratify observations by}

\item{includeVarNames}{boolean indicating if the variable names should be
included in the output table, default is FALSE}

\item{digits}{the number of digits in the survival rate}

\item{showCols}{character vector indicating which of the optional columns
to display, defaults to c('N','Observed','Expected')}

\item{CIwidth}{width of the median survival estimates, default is 95\%}

\item{conf.type}{type of confidence interval see
\code{\link[survival:survfit]{survival::survfit}} for details. Default is 'log'.}

\item{caption}{table caption}

\item{tableOnly}{should a dataframe or a formatted object be returned}

\item{fontsize}{PDF/HTML output only, manually set the table fontsize}
}
\value{
A character vector of the survival table source code, unless tableOnly=TRUE in
which case a data frame is returned
}
\description{
This is a wrapper function around the survdiff function to display overall
event rates and group-specific rates along with the log-rank test of a
difference in survival between groups in a single table suitable for
markdown output. Median survival times are included by default but can be
removed setting median=FALSE
}
\examples{
#' # Differences between sex
data("pembrolizumab")
rm_survdiff(data=pembrolizumab,time='os_time',status='os_status',
covs='sex',digits=1)

# Differences between sex, stratified by cohort
rm_survdiff(data=pembrolizumab,time='os_time',status='os_status',
covs='sex',strata='cohort',digits=1)
# Differences between sex/cohort groups
rm_survdiff(data=pembrolizumab,time='os_time',status='os_status',
covs=c('sex','cohort'),digits=1)
}
\seealso{
\code{\link[survival:survdiff]{survival::survdiff}}
}
