% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NPSimulation.R
\name{calcPHatMATestStatistics}
\alias{calcPHatMATestStatistics}
\title{calcPHatMATestStatistics}
\usage{
calcPHatMATestStatistics(
  effectsize,
  effectsize.variance,
  effectsize.df = 0,
  alpha = 0.05,
  alternative = "two.sided"
)
}
\arguments{
\item{effectsize}{The overall estimate of the centralized PHat (ie.Phat-0.5) from a group of effect sizes to be meta-analysed}

\item{effectsize.variance}{The estimate of the variance of the overall estimate ofPHat}

\item{effectsize.df}{The total degrees of freedom for the set of effect sizes. If effectsize.df>0, the confidence intervals, pvalues and significance test use the t-distribution probability values. If effectsize.df=0 (default), the confidence intervals, the pvalues and significance test use the normal distribution probability values.}

\item{alpha}{The significance level used to control the significance tests and calculation of confidence limits (default 0.05).}

\item{alternative}{Specifies the type of significance test and can take the values "two.sided" (default), "less" or "greater"}
}
\value{
ES.test The value of the t-statistic

ES.pvalue The p-value of the t-test if the parameter d.df>0, or the normal probability value if d.df=0

ES.sig The significance of the statistical test of the d.tvalue return value at the alpha level for one sided tests and aplha/2 for two sided tests as specified by the input parameter alternative.

ES.ci.lower The lower 100*(1-alpha/2)% confidence interval of the average centralized PHat based on the t-distribution probability values if effectsize.df>0 or normal probability values if effectsize.df=0

ES.ci.upper The upper 100*(1-alpha/2)% confidence interval of the average centralized PHat based on the t-distribution probability values if effectsize.df>0 or normal probability values if effectsize.df=0
}
\description{
This function is a helper function for meta-analysis of experiments using PHat as an effect size. It returns the 100*(1-alpha/2)% confidence intervals,the value of the t-test, the probability associated with the null hypothesis and the significance of the test. The confidence intervals, pvalue and the significance of the statistical test vary according to the value of the "alternative" parameter and whether or not degrees of freedom are specifed.
}
\examples{
avePHat=mean(c(0.92,0.6,0.48,0.72,0.88))
avePHatvar=sum(c(0.01,0.04,0.05,0.04,0.01))/25
PHatdf=sum(c(6.63,6.63,5.08,5.61,8))
calcPHatMATestStatistics(effectsize=avePHat-0.5,effectsize.variance=avePHatvar,effectsize.df=PHatdf)
# A tibble: 1 x 5
#   ES.test ES.pvalue ES.sig ES.ci.lower ES.ci.upper
#     <dbl>     <dbl> <lgl>        <dbl>       <dbl>
# 1    2.84   0.00778 TRUE        0.0622       0.378
}
\author{
Barbara Kitchenham and Lech Madeyski
}
