% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/func_hsic.R
\name{hsic}
\alias{hsic}
\title{Hilbert Schmidt Independence Criterion}
\usage{
hsic(mats, kernel_type = NULL, estimator = NULL)
}
\arguments{
\item{mats}{A list of length \eqn{M} containing data matrices of size 
\eqn{(n_\mathrm{samples},\, p_k)}. All matrices must share the same number of rows for matching samples.}

\item{kernel_type}{Character scalar indicating the kernel. Defaults to \code{"rbf"} (if \code{NULL}). 
See \code{\link{repsim_kernels}} for a list of available kernels.}

\item{estimator}{Character scalar indicating the HSIC estimator. Defaults to \code{"gretton"} (if \code{NULL}). 
See \code{\link{repsim_hsic}} for a list of available estimators.}
}
\value{
An \eqn{M \times M} matrix of HSIC values.
}
\description{
Compute pairwise HSIC similarities between multiple representations using a
chosen kernel and estimator.
}
\examples{
\donttest{
# --------------------------------------------------
# Use "iris" and "USArrests" datasets
#   1. apply scaling to reduce the effect of scales
#   2. add white noise to create multiple representations
#   3. generate 10 perturbations per each dataset
# --------------------------------------------------
# prepare the prototype
set.seed(1)
X = as.matrix(scale(as.matrix(iris[sample(1:150, 50, replace=FALSE),1:4])))
Y = as.matrix(scale(as.matrix(USArrests)))
n = nrow(X)
p_X = ncol(X)
p_Y = ncol(Y)

# generate 10 of each by perturbation
mats = vector("list", length=20L)
for (i in 1:10){
  mats[[i]] = X + matrix(rnorm(n*p_X, sd=1), nrow=n)
}
for (j in 11:20){
  mats[[j]] = Y + matrix(rnorm(n*p_Y, sd=1), nrow=n)
}

# compute similarity with rbf kernel and different estimators
hsic1 = hsic(mats, estimator="gretton")
hsic2 = hsic(mats, estimator="song")
hsic3 = hsic(mats, estimator="lange")

# visualize
opar <- par(no.readonly=TRUE)
labs <- paste0("rep ",1:20)
par(mfrow=c(1,3), pty="s")

image(hsic1[,20:1], axes=FALSE, main="HSIC (Gretton)")
axis(1, seq(0, 1, length.out=20), labels = labs, las = 2)
axis(2, at = seq(0, 1, length.out=20), labels = labs[20:1], las = 2)

image(hsic2[,20:1], axes=FALSE, main="HSIC (Song)")
axis(1, seq(0, 1, length.out=20), labels = labs, las = 2)
axis(2, at = seq(0, 1, length.out=20), labels = labs[20:1], las = 2)

image(hsic3[,20:1], axes=FALSE, main="HSIC (Lange)")
axis(1, seq(0, 1, length.out=20), labels = labs, las = 2)
axis(2, at = seq(0, 1, length.out=20), labels = labs[20:1], las = 2)
par(opar)
}

}
\references{
\insertRef{gretton_2005_MeasuringStatisticalDependence}{repsim}
}
