% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/body.R
\name{api_body}
\alias{api_body}
\alias{api_body_}
\title{Query construction}
\usage{
api_body(.data, ..., body_value = NULL)

api_body_(.data, ..., .dots, body_value = NULL)
}
\arguments{
\item{.data}{Result of a call to \code{api}}

\item{...}{Comma separated list of unquoted variable names. These are combined into
a list and passed to whatever http method is used downstream}

\item{body_value}{one of the following:
\itemize{
 \item FALSE: No body
 \item NULL: An empty body
 \item "": A length 0 body
 \item upload_file("path/"): The contents of a file. The mime type will be guessed
 from the extension, or can be supplied explicitly as the second argument
 to upload_file()
 \item A character or raw vector: sent as is in body. Use content_type to tell the
 server what sort of data you are sending.
}}

\item{.dots}{Used to work around non-standard evaluation}
}
\description{
Query construction
}
\examples{
\dontrun{
## NSE
dd <- api("http://httpbin.org/post")
dd \%>\% api_body(body_value = NULL) \%>\% http("POST")
dd \%>\% api_body(body_value = "") \%>\% http("POST")

## other named parameters are passed as form values
dd \%>\% api_body(x = hello) \%>\% http("POST")

# upload a file
file <- "~/some_test.txt"
cat("hello, world", file = file)
dd \%>\% api_body(x = upload_file("~/some_test.txt")) \%>\% http("POST")

# A named list
dd \%>\% api_body(x = hello, y = stuff) \%>\% http("POST")

## SE
dd \%>\% api_body_(x = "hello", y = "stuff") \%>\% http("POST")
}
}
\seealso{
Other dsl: \code{\link{api_config}},
  \code{\link{api_error_handler}}, \code{\link{api_query}},
  \code{\link{api}}, \code{\link{auth}}
}

