% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_empirical.R
\name{dist_empirical}
\alias{dist_empirical}
\title{Empirical distribution}
\usage{
dist_empirical(sample, positive = FALSE, bw = "nrd0")
}
\arguments{
\item{sample}{Sample to build the empirical distribution from}

\item{positive}{Is the underlying distribution known to be positive?
This will effect the density estimation procedure.
\code{positive = FALSE} uses a kernel density estimate produced by \code{\link[=density]{density()}},
\code{positive = TRUE} uses a log-kernel density estimate produced by
\code{\link[logKDE:logdensity_fft]{logKDE::logdensity_fft()}}. The latter can improve density estimation near
zero.}

\item{bw}{Bandwidth parameter for density estimation. Passed to the density
estimation function selected by \code{positive}.}
}
\value{
An \code{EmpiricalDistribution} object.
}
\description{
Creates an empirical distribution object from a sample.
Assumes iid. samples. \code{with_params} should \strong{not} be used with this
distribution because estimation of the relevant indicators happens during
construction.
}
\details{
\itemize{
\item \code{sample()} samples iid. from \code{sample}. This approach is similar to
bootstrapping.
\item \code{density()} evaluates a kernel density estimate, approximating with zero
outside of the known support. This estimate is either obtained using
\link[stats:density]{stats::density} or \link[logKDE:logdensity_fft]{logKDE::logdensity_fft}, depending on \code{positive}.
\item \code{probability()} evaluates the empirical cumulative density function
obtained by \link[stats:ecdf]{stats::ecdf}.
\item \code{quantile()} evaluates the empirical quantiles using \link[stats:quantile]{stats::quantile}
\item \code{hazard()} estimates the hazard rate using the density estimate and the
empirical cumulative density function: \code{h(t) = df(t) / (1 - cdf(t))}.
}
}
\examples{
x <- rexp(20, rate = 1)
dx <- dist_empirical(sample = x, positive = TRUE)

y <- rnorm(20)
dy <- dist_empirical(sample = y)

plot_distributions(
  exponential = dx,
  normal = dy,
  .x = seq(-3, 3, length.out = 100)
)

}
\seealso{
Other Distributions: 
\code{\link{Distribution}},
\code{\link{dist_bdegp}()},
\code{\link{dist_beta}()},
\code{\link{dist_binomial}()},
\code{\link{dist_blended}()},
\code{\link{dist_dirac}()},
\code{\link{dist_discrete}()},
\code{\link{dist_erlangmix}()},
\code{\link{dist_exponential}()},
\code{\link{dist_gamma}()},
\code{\link{dist_genpareto}()},
\code{\link{dist_lognormal}()},
\code{\link{dist_mixture}()},
\code{\link{dist_negbinomial}()},
\code{\link{dist_normal}()},
\code{\link{dist_pareto}()},
\code{\link{dist_poisson}()},
\code{\link{dist_translate}()},
\code{\link{dist_trunc}()},
\code{\link{dist_uniform}()},
\code{\link{dist_weibull}()}
}
\concept{Distributions}
