% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rp_indices.R
\name{rp.indices}
\alias{rp.indices}
\title{Extract indices from a ResponsePatterns object}
\usage{
rp.indices(rp.object, round = 2, include.coefs = TRUE)
}
\arguments{
\item{rp.object}{A ResponsePatterns object.}

\item{round}{An integer. The number of decimal places to which the indices should be rounded.}

\item{include.coefs}{A logical scalar. Should the returned data frame include also the coefficients?}
}
\value{
Returns a data frame.
}
\description{
This function extracts indices from a ResponsePatterns object.
}
\examples{
rp <- rp.acors(rp.simdata, id.var="optional_ID")
rp.indices(rp)
}
\seealso{
\code{\link{rp.acors}}, \code{\link{rp.patterns}}
}
