/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints;

import gnu.trove.iterator.TIntIterator;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.chocosolver.solver.ISelf;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.extension.Tuples;
import org.chocosolver.solver.constraints.nary.automata.FA.IAutomaton;
import org.chocosolver.solver.constraints.nary.flow.PropMinCostMaxFlow;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.solver.expression.discrete.arithmetic.ArExpression;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.Task;
import org.chocosolver.util.tools.ArrayUtils;

public interface IDecompositionFactory
extends ISelf<Model> {
    default public void amongDec(IntVar nbVar, IntVar[] vars, IntVar[] values) {
        BoolVar[] ins = ((Model)this.ref()).boolVarArray("ins", vars.length);
        for (int i = 0; i < vars.length; ++i) {
            BoolVar[] eqs = ((Model)this.ref()).boolVarArray("ins", values.length);
            for (int j = 0; j < values.length; ++j) {
                ((Model)this.ref()).reifyXeqY(vars[i], values[j], eqs[j]);
            }
            ((Model)this.ref()).addClausesBoolOrArrayEqVar(eqs, ins[i]);
        }
        ((Model)this.ref()).sum(ins, "=", nbVar).post();
    }

    default public void cumulativeTimeDec(IntVar[] starts, int[] durations, int[] heights, int capacity) {
        int n = starts.length;
        int min_t = Integer.MAX_VALUE;
        int max_t = Integer.MIN_VALUE;
        for (int i = 0; i < n; ++i) {
            min_t = Math.min(min_t, starts[i].getLB());
            max_t = Math.max(max_t, starts[i].getUB() + durations[i]);
        }
        for (int t = min_t; t <= max_t; ++t) {
            IntVar[] bit = ((Model)this.ref()).boolVarArray(String.format("b_%s_", t), n);
            for (int i = 0; i < n; ++i) {
                ((Model)this.ref()).addClausesBoolAndArrayEqVar(new BoolVar[]{((Model)this.ref()).isLeq(starts[i], t), ((Model)this.ref()).isGeq(starts[i], t - durations[i] + 1)}, (BoolVar)bit[i]);
            }
            ((Model)this.ref()).scalar(bit, Arrays.stream(heights, 0, n).toArray(), "<=", capacity).post();
        }
    }

    default public void cumulativeDec(Task[] tasks, IntVar[] heights, IntVar capacity) {
        this.cumulativeDec((IntVar[])Arrays.stream(tasks).map(Task::getStart).toArray(IntVar[]::new), (IntVar[])Arrays.stream(tasks).map(Task::getDuration).toArray(IntVar[]::new), heights, capacity);
    }

    default public void cumulativeDec(IntVar[] starts, IntVar[] durations, IntVar[] heights, IntVar capacity) {
        int n = starts.length;
        int min_t = Integer.MAX_VALUE;
        int max_t = Integer.MIN_VALUE;
        for (int i = 0; i < n; ++i) {
            min_t = Math.min(min_t, starts[i].getLB());
            if ((max_t = Math.max(max_t, starts[i].getUB() + durations[i].getUB())) - min_t > 5000) break;
        }
        if (max_t - min_t > 5000) {
            for (int j = 0; j < n; ++j) {
                BoolVar[] bit = ((Model)this.ref()).boolVarArray(String.format("b_%s_", j), n);
                IntVar[] hs = new IntVar[n];
                for (int i = 0; i < n; ++i) {
                    BoolVar b1 = ((Model)this.ref()).boolVar(String.format("%s \u2264 %s", starts[i].getName(), starts[j].getName()));
                    ((Model)this.ref()).reifyXleY(starts[i], starts[j], b1);
                    BoolVar b2 = ((Model)this.ref()).boolVar(String.format("%s < %s + %s", starts[j].getName(), starts[i].getName(), durations[i].getName()));
                    ((Model)this.ref()).scalar(new IntVar[]{starts[j], starts[i]}, new int[]{1, -1}, "<", durations[i]).reifyWith(b2);
                    ((Model)this.ref()).addClausesBoolAndArrayEqVar(new BoolVar[]{b1, b2}, bit[i]);
                    hs[i] = ((Model)this.ref()).intVar("nH" + i + "_" + j, 0, heights[i].getUB());
                    ((Model)this.ref()).times((IntVar)bit[i], heights[i], hs[i]).post();
                }
                ((Model)this.ref()).sum(hs, "<=", capacity).post();
            }
        } else {
            for (int t = min_t; t <= max_t; ++t) {
                BoolVar[] bit = ((Model)this.ref()).boolVarArray(String.format("b_%s_", t), n);
                IntVar[] hs = new IntVar[n];
                for (int i = 0; i < n; ++i) {
                    BoolVar b1 = ((Model)this.ref()).isLeq(starts[i], t);
                    BoolVar b2 = ((Model)this.ref()).boolVar(String.format("(%d < %s + %s)", t, starts[i].getName(), durations[i].getName()));
                    ((Model)this.ref()).reifyXgtYC(starts[i], ((Model)this.ref()).intView(-1, durations[i], t), 0, b2);
                    ((Model)this.ref()).addClausesBoolAndArrayEqVar(new BoolVar[]{b1, b2}, bit[i]);
                    hs[i] = ((Model)this.ref()).intVar("nH" + i + "_" + t, 0, heights[i].getUB());
                    ((Model)this.ref()).times((IntVar)bit[i], heights[i], hs[i]).post();
                }
                ((Model)this.ref()).sum(hs, "<=", capacity).post();
            }
        }
    }

    default public void element(IntVar value, int[][] matrix, IntVar rowIndex, int rowOffset, IntVar colIndex, int colOffset) {
        int d0 = matrix.length;
        int d1 = matrix[0].length;
        IntVar rv = ((Model)this.ref()).intView(1, rowIndex, -rowOffset);
        IntVar cv = ((Model)this.ref()).intView(1, colIndex, -colOffset);
        IntVar idx = ((Model)this.ref()).intVar(0, d0 * d1 - 1);
        ((Model)this.ref()).scalar(new IntVar[]{rv, cv}, new int[]{d1, 1}, "=", idx).post();
        int[] mvars = ArrayUtils.flatten(matrix);
        ((Model)this.ref()).element(value, mvars, idx, 0).post();
    }

    default public void element(IntVar value, IntVar[][] matrix, IntVar rowIndex, int rowOffset, IntVar colIndex, int colOffset) {
        int d0 = matrix.length;
        int d1 = matrix[0].length;
        IntVar rv = ((Model)this.ref()).intView(1, rowIndex, -rowOffset);
        IntVar cv = ((Model)this.ref()).intView(1, colIndex, -colOffset);
        IntVar idx = ((Model)this.ref()).intVar(0, d0 * d1 - 1);
        ((Model)this.ref()).scalar(new IntVar[]{rv, cv}, new int[]{d1, 1}, "=", idx).post();
        IntVar[] mvars = ArrayUtils.flatten(matrix);
        ((Model)this.ref()).element(value, mvars, idx, 0).post();
    }

    default public void globalCardinalityDec(IntVar[] vars, IntVar[] values, IntVar[] occurrences, boolean closed) {
        if (!1.$assertionsDisabled && values.length != occurrences.length) {
            throw new AssertionError();
        }
        for (int i2 = 0; i2 < values.length; ++i2) {
            ((Model)this.ref()).count(values[i2], vars, occurrences[i2]).post();
        }
        if (closed) {
            SetVar svars = ((Model)this.ref()).setVar(new int[0], Arrays.stream(vars).flatMapToInt(IntVar::stream).boxed().collect(Collectors.toSet()).stream().mapToInt(i -> i).sorted().toArray());
            SetVar svalues = ((Model)this.ref()).setVar(new int[0], Arrays.stream(values).flatMapToInt(IntVar::stream).boxed().collect(Collectors.toSet()).stream().mapToInt(i -> i).sorted().toArray());
            ((Model)this.ref()).subsetEq(svars, svalues).post();
        }
    }

    default public IntVar[] regularDec(IntVar[] vars, IAutomaton automaton) {
        int n = vars.length;
        IntVar[] states = new IntVar[n + 1];
        TIntHashSet[] layer = new TIntHashSet[n + 1];
        for (int i = 0; i <= n; ++i) {
            layer[i] = new TIntHashSet();
        }
        layer[0].add(automaton.getInitialState());
        states[0] = ((Model)this.ref()).intVar("Q_" + ((Model)this.ref()).nextId(), layer[0].toArray());
        TIntHashSet nexts = new TIntHashSet();
        for (int i = 0; i < n; ++i) {
            int ub = vars[i].getUB();
            Tuples tuples = new Tuples(true);
            int j = vars[i].getLB();
            while (j <= ub) {
                TIntIterator layerIter = layer[i].iterator();
                while (layerIter.hasNext()) {
                    int k = layerIter.next();
                    nexts.clear();
                    automaton.delta(k, j, nexts);
                    TIntIterator it = nexts.iterator();
                    while (it.hasNext()) {
                        int succ = it.next();
                        if (i + 1 >= n && !automaton.isFinal(succ)) continue;
                        layer[i + 1].add(succ);
                        tuples.add(k, succ, j);
                    }
                }
                j = vars[i].nextValue(j);
            }
            states[i + 1] = ((Model)this.ref()).intVar("Q_" + ((Model)this.ref()).nextId(), layer[i + 1].toArray());
            ((Model)this.ref()).table(new IntVar[]{states[i], states[i + 1], vars[i]}, tuples, "CT+").post();
        }
        return states;
    }

    default public void binPackingDec(IntVar[] bin, int[] w, IntVar[] load, int offset) {
        int i;
        ((Model)this.ref()).sum(load, "=", Arrays.stream(w).sum()).post();
        for (i = 0; i < bin.length; ++i) {
            ((Model)this.ref()).member(bin[i], offset, load.length - 1 + offset).post();
        }
        for (i = 0; i < load.length; ++i) {
            IntVar[] in = new BoolVar[bin.length];
            for (int j = 0; j < bin.length; ++j) {
                in[j] = ((Model)this.ref()).isEq(bin[j], i + offset);
            }
            ((Model)this.ref()).scalar(in, w, "=", load[i]).post();
        }
    }

    default public void circuitDec(IntVar[] S, int offset) {
        int n = S.length;
        ((Model)this.ref()).allDifferent(S, "AC").post();
        IntVar[] t = ((Model)this.ref()).intVarArray("t", n - 1, offset + 1, n + offset - 1);
        ((Model)this.ref()).allDifferent(t, "AC").post();
        ((Model)this.ref()).arithm(t[0], "=", S[0]).post();
        for (int i = 1; i < n - 2; ++i) {
            ((Model)this.ref()).element(t[i], S, t[i - 1], offset).post();
        }
        ((Model)this.ref()).element(((Model)this.ref()).intVar(offset), S, t[n - 2], offset).post();
    }

    default public void argmaxDec(IntVar z, int offset, IntVar[] vars) {
        int n = vars.length;
        int min = Stream.of(vars).mapToInt(IntVar::getLB).min().getAsInt();
        int max = Stream.of(vars).mapToInt(IntVar::getUB).max().getAsInt();
        IntVar[] q = new IntVar[n];
        IntVar M = ((Model)this.ref()).intVar("M", n * min, n * (max + 1));
        z.ge(offset).post();
        z.lt(vars.length + offset).post();
        for (int j = 0; j < n; ++j) {
            q[j] = ((Model)this.ref()).intView(n, vars[j], n - j);
            z.ne(j + offset).iff(M.gt(q[j])).post();
        }
        ((Model)this.ref()).max(M, q).post();
    }

    default public void argminDec(IntVar z, int offset, IntVar[] vars) {
        int n = vars.length;
        int min = Stream.of(vars).mapToInt(IntVar::getLB).min().getAsInt();
        int max = Stream.of(vars).mapToInt(IntVar::getUB).max().getAsInt();
        IntVar[] q = new IntVar[n];
        IntVar M = ((Model)this.ref()).intVar("M", n * min, n * (max + 1));
        z.ge(offset).post();
        z.lt(vars.length + offset).post();
        for (int j = 0; j < n; ++j) {
            q[j] = ((Model)this.ref()).intView(n, vars[j], j);
            z.ne(j + offset).iff(M.lt(q[j])).post();
        }
        ((Model)this.ref()).min(M, q).post();
    }

    default public void ifThenElseDec(BoolVar[] c, int[] x, IntVar y) {
        Tuples tuples = new Tuples();
        int star = Math.max(2, y.getUB() + 1);
        tuples.setUniversalValue(star);
        int[] t = new int[c.length + 1];
        Arrays.fill(t, 0);
        t[c.length] = star;
        tuples.add((int[])t.clone());
        Arrays.fill(t, star);
        for (int i = 0; i < c.length; ++i) {
            if (i > 0) {
                t[i - 1] = 0;
            }
            t[i] = 1;
            t[c.length] = x[i];
            tuples.add((int[])t.clone());
        }
        ((Model)this.ref()).table(ArrayUtils.append(new IntVar[][]{c, {y}}), tuples).post();
    }

    default public void ifThenElseDec(BoolVar[] c, IntVar[] x, IntVar y) {
        Tuples tuples = new Tuples();
        int univ = Math.max(2, y.getUB() + 1);
        tuples.setUniversalValue(univ);
        int[] t = new int[c.length + 1];
        Arrays.fill(t, 0);
        t[c.length] = c.length;
        tuples.add((int[])t.clone());
        Arrays.fill(t, univ);
        int i = 0;
        while (i < c.length) {
            if (i > 0) {
                t[i - 1] = 0;
            }
            t[i] = 1;
            t[c.length] = i++;
            tuples.add((int[])t.clone());
        }
        IntVar idx = ((Model)this.ref()).intVar(0, c.length);
        ((Model)this.ref()).table(ArrayUtils.append(new IntVar[][]{c, {idx}}), tuples).post();
        ((Model)this.ref()).element(y, ArrayUtils.append(x, {y}), idx, 0).post();
    }

    default public void product(IntVar[][] A, IntVar[][] B, IntVar[][] C) {
        if (!(1.$assertionsDisabled || A.length > 0 && B.length > 0 && C.length > 0)) {
            throw new AssertionError();
        }
        if (!(1.$assertionsDisabled || A[0].length > 0 && B[0].length > 0 && C[0].length > 0)) {
            throw new AssertionError();
        }
        if (!1.$assertionsDisabled && A[0].length != B[0].length) {
            throw new AssertionError();
        }
        if (!1.$assertionsDisabled && A.length != C.length) {
            throw new AssertionError();
        }
        if (!1.$assertionsDisabled && B[0].length != C[0].length) {
            throw new AssertionError();
        }
        int n = B.length;
        int m = C.length;
        int p = C[0].length;
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < p; ++j) {
                int finalI = i;
                int finalJ = j;
                ((Model)this.ref()).sum((IntVar[])IntStream.range(0, n).mapToObj(k -> A[finalI][k].mul((ArExpression)B[k][finalJ]).intVar()).toArray(IntVar[]::new), "=", C[i][j]).post();
            }
        }
    }

    default public void product(BoolVar[][] A, BoolVar[][] B, BoolVar[][] C) {
        if (!(1.$assertionsDisabled || A.length > 0 && B.length > 0 && C.length > 0)) {
            throw new AssertionError();
        }
        if (!(1.$assertionsDisabled || A[0].length > 0 && B[0].length > 0 && C[0].length > 0)) {
            throw new AssertionError();
        }
        if (!1.$assertionsDisabled && A[0].length != B[0].length) {
            throw new AssertionError();
        }
        if (!1.$assertionsDisabled && A.length != C.length) {
            throw new AssertionError();
        }
        if (!1.$assertionsDisabled && B[0].length != C[0].length) {
            throw new AssertionError();
        }
        int n = B.length;
        int m = C.length;
        int p = C[0].length;
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < p; ++j) {
                int finalI = i;
                int finalJ = j;
                ((Model)this.ref()).addClausesBoolOrArrayEqVar((BoolVar[])IntStream.range(0, n).mapToObj(k -> A[finalI][k].and(B[k][finalJ]).boolVar()).toArray(BoolVar[]::new), C[i][j]);
            }
        }
    }

    default public void costFlow(int[] starts, int[] ends, int[] supplies, int[] unitCosts, IntVar[] flows, IntVar cost, int offset) {
        ((Model)this.ref()).scalar(flows, unitCosts, "=", cost).post();
        for (int i = 0; i < supplies.length; ++i) {
            int io = i + offset;
            ArrayList<IntVar> src = new ArrayList<IntVar>();
            ArrayList<IntVar> snk = new ArrayList<IntVar>();
            for (int j = 0; j < starts.length; ++j) {
                if (starts[j] == io) {
                    src.add(flows[j]);
                }
                if (ends[j] != io) continue;
                snk.add(flows[j]);
            }
            snk.add(((Model)this.ref()).intVar(supplies[i]));
            ((Model)this.ref()).sum(src.toArray(new IntVar[0]), "=", snk.toArray(new IntVar[0])).post();
        }
        new Constraint("", new PropMinCostMaxFlow(starts, ends, supplies, unitCosts, flows, cost, offset)).post();
    }

    default public void intValuePrecedeChainDec(IntVar[] X, int S, int T) {
        Model model = X[0].getModel();
        model.arithm(X[0], "!=", T).post();
        for (int j = 1; j < X.length; ++j) {
            BoolVar bj = model.arithm(X[j], "=", T).reify();
            BoolVar[] bis = new BoolVar[j];
            for (int i = 0; i < j; ++i) {
                bis[i] = model.arithm(X[i], "=", S).reify();
            }
            model.ifThen(bj, model.or(bis));
        }
    }

    default public void intValuePrecedeChainDec(IntVar[] X, int[] V) {
        if (V.length > 1) {
            TIntHashSet values = new TIntHashSet();
            values.add(V[0]);
            for (int i = 1; i < V.length; ++i) {
                if (values.contains(V[i])) {
                    throw new SolverException("\"int_value_precede\" requires V to be made of distinct values");
                }
                values.add(V[i]);
                this.intValuePrecedeChainDec(X, V[i - 1], V[i]);
            }
        }
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

