/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.extension.nary;

import org.chocosolver.solver.constraints.extension.Tuples;
import org.chocosolver.solver.constraints.extension.nary.TuplesList;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.solver.variables.IntVar;

class IterTuplesTable
extends TuplesList {
    private final int nbVar;
    private final int[] lowerbounds;
    private final int[] ranges;
    private final int[][][] table;

    public IterTuplesTable(Tuples tuples, IntVar[] vars) {
        super(tuples, vars);
        int i;
        this.nbVar = vars.length;
        this.lowerbounds = new int[this.nbVar];
        this.ranges = new int[this.nbVar];
        for (i = 0; i < this.nbVar; ++i) {
            this.lowerbounds[i] = vars[i].getLB();
            this.ranges[i] = vars[i].getUB() - this.lowerbounds[i] + 1;
        }
        this.table = new int[this.nbVar][][];
        for (i = 0; i < this.nbVar; ++i) {
            this.table[i] = new int[this.ranges[i]][];
            int[] nbsups = this.getNbSupportFor(i);
            for (int j = 0; j < nbsups.length; ++j) {
                this.table[i][j] = new int[nbsups[j]];
            }
        }
        this.buildInitialListOfSupports();
    }

    private IterTuplesTable(int[][] tuplesIndexes, int n, int[] lowerbounds, int[] ranges, int[][][] table) {
        super(tuplesIndexes);
        this.nbVar = n;
        this.lowerbounds = lowerbounds;
        this.ranges = ranges;
        this.table = table;
    }

    public int[] getNbSupportFor(int i) {
        int[] nbsup = new int[this.ranges[i]];
        for (int[] tuple : this.tuplesIndexes) {
            int n = tuple[i] - this.lowerbounds[i];
            nbsup[n] = nbsup[n] + 1;
        }
        return nbsup;
    }

    public void buildInitialListOfSupports() {
        int cpt = 0;
        int[][] level = new int[this.nbVar][];
        for (int i = 0; i < this.nbVar; ++i) {
            level[i] = new int[this.ranges[i]];
        }
        for (int[] tuple : this.tuplesIndexes) {
            for (int i = 0; i < tuple.length; ++i) {
                int value = tuple[i] - this.lowerbounds[i];
                this.table[i][value][level[i][value]] = cpt;
                int[] nArray = level[i];
                int n = value;
                nArray[n] = nArray[n] + 1;
            }
            ++cpt;
        }
    }

    public int[][][] getTableLists() {
        return this.table;
    }

    public int seekNextTuple(int oldidx, int var, int val) {
        int nidx = oldidx + 1;
        if (nidx < this.table[var][val].length) {
            return this.table[var][val][nidx];
        }
        return -1;
    }

    public int getNbSupport(int var, int val) {
        return this.table[var][val].length;
    }

    public int getRelationOffset(int var) {
        return this.lowerbounds[var];
    }

    @Override
    public boolean checkTuple(int[] tuple) {
        throw new SolverException("checkTuple should not be used on an IterRelation");
    }
}

