/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.trace;

import org.chocosolver.solver.Solver;
import org.chocosolver.solver.search.loop.monitors.IMonitorClose;
import org.chocosolver.solver.search.loop.monitors.IMonitorInitialize;
import org.chocosolver.solver.search.loop.monitors.IMonitorSolution;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.util.ESat;

public class VerboseSolving
implements IMonitorInitialize,
IMonitorSolution,
IMonitorClose {
    private final Thread printer;
    private final Solver solver;
    private final long[] counters = new long[4];
    private volatile boolean alive;
    private int calls = 0;

    public VerboseSolving(Solver solver, long duration) {
        this.solver = solver;
        this.printer = new Thread(() -> {
            this.alive = true;
            try {
                Thread.sleep(duration);
                do {
                    this.body(false);
                    Thread.sleep(duration);
                } while (this.alive);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
        this.printer.setDaemon(true);
    }

    @Override
    public void afterInitialize(boolean correct) {
        if (correct && !this.printer.isAlive()) {
            this.printer.start();
        }
    }

    @Override
    public void onSolution() {
        this.body(true);
    }

    @Override
    public void afterClose() {
        if (this.solver.isFeasible().equals((Object)ESat.FALSE)) {
            this.alive = false;
            this.printer.interrupt();
        }
    }

    private void header() {
        boolean opt = this.solver.getObjectiveManager().isOptimization();
        this.solver.log().white().printf((opt ? "          Objective        |" : "") + "                 Measures                |     Progress    %n" + (opt ? "     CurrentDomain BestBnd |" : "") + " Depth Decisions WrongDecs  Failures Restarts | SolCount   Time |%n", new Object[0]);
    }

    private void body(boolean onSol) {
        boolean opt;
        if (this.calls % 20 == 0) {
            this.header();
        }
        if (opt = this.solver.getObjectiveManager().isOptimization()) {
            this.bodyOpt(onSol);
        } else {
            this.bodySat(onSol);
        }
        this.counters[0] = this.solver.getNodeCount();
        this.counters[1] = this.solver.getFailCount();
        this.counters[2] = this.solver.getBackTrackCount();
        this.counters[3] = this.solver.getRestartCount();
        ++this.calls;
    }

    private void bodySat(boolean onSol) {
        this.solver.log().white().printf("%s %5d %9d %9d %9d %8d | %8d %5.0fs |%s%n%s", onSol ? "\u001b[1m\u001b[30m" : "\u001b[37m", this.solver.getCurrentDepth(), this.solver.getNodeCount() - this.counters[0], this.solver.getBackTrackCount() - this.counters[2], this.solver.getFailCount() - this.counters[1], this.solver.getRestartCount() - this.counters[3], this.solver.getSolutionCount(), Float.valueOf(this.solver.getTimeCount()), onSol ? "*" : "", "\u001b[0m");
    }

    private void bodyOpt(boolean onSol) {
        IntVar obj = this.solver.getObjectiveManager().getObjective().asIntVar();
        Number best = this.solver.getObjectiveManager().getBestSolutionValue();
        this.solver.log().white().printf("%s%8d %8d %8s | %5d %9d %9d %9d %8d | %8d %5.0fs |%s%n%s", onSol ? "\u001b[1m\u001b[30m" : "\u001b[37m", obj.getLB(), obj.getUB(), this.solver.getSolutionCount() > 0L ? best : "--", this.solver.getCurrentDepth(), this.solver.getNodeCount() - this.counters[0], this.solver.getBackTrackCount() - this.counters[2], this.solver.getFailCount() - this.counters[1], this.solver.getRestartCount() - this.counters[3], this.solver.getSolutionCount(), Float.valueOf(this.solver.getTimeCount()), onSol ? "*" : "", "\u001b[0m");
    }
}

