% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_dataset_retentionmort.R
\name{test_dataset_retentionmort}
\alias{test_dataset_retentionmort}
\title{Generate a test dataset that can be input into the retentionmort() function}
\usage{
test_dataset_retentionmort()
}
\value{
c =     One value for the total number of tagging efforts that is 6 or
greater.

err =   A value (between 1 and 26) that represents the weekly mortality rate
and weekly tag loss rate from a preloaded case study listed in the
metadata.

n_c1 =  A vector of the number of tagged individuals in one of two
categorical variables.

nT =    A vector of the number of tagged individuals for each tagging effort.

R =     A vector of the number of recaptured individuals per effort.

TaL =   A vector of the cumulative number of tagged individuals following
each effort.
}
\description{
Using the example code verbatim, this function will produce a series of
outputs that can be directly input into the retentionmort() function.
}
\examples{

#Run this verbatim to produce a single mark-recapture dataset
ret_env <- new.env()
data<- test_dataset_retentionmort()
list2env(data, envir = ret_env)

}
