% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flsgen_create_landscape_structure.R
\name{flsgen_create_landscape_structure}
\alias{flsgen_create_landscape_structure}
\title{Creates a predefined landscape structure that can be converted as JSON
Input for flsgen generate}
\usage{
flsgen_create_landscape_structure(
  nb_rows,
  nb_cols,
  classes,
  mask_raster = NULL
)
}
\arguments{
\item{nb_rows}{Number of rows}

\item{nb_cols}{Number of columns}

\item{classes}{list of class structures}

\item{mask_raster}{mask raster (path or terra::rast object)}
}
\value{
A landscape structure object which can be converted to JSON for
flsgen generate
}
\description{
Creates a predefined landscape structure that can be converted as JSON
converted as JSON Input for flsgen generate.
}
\details{
The class structures must be created prior to the call to this function

Either nb_rows and nb_cols, or mask_raster must be specified. The dimensions
of the landscape are deduced from the mask raster if it is used.
}
\examples{
  \dontrun{
    cls_1 <- flsgen_class_structure("class 1", c(10, 100, 1000))
    cls_2 <- flsgen_class_structure("class 2", c(20, 200, 2000))
    ls_struct <- flsgen_landscape_structure(200, 200, list(cls_1, cls_2))
  }

}
