#' Get List of All Orders for the User
#'
#' @name list_orders
#'
#' @description This is an auth based function. User must have valid api keys generated by GDAX which must be passed as mandatory arguments. The function will return all open orders by default for Bitcoin This is an extension of \code{\link{open_orders}}.
#'
#' @param api.key Mandatory character value. This is the API key as generated by GDAX. Typically a 32 character value.
#' @param secret Mandatory character value. This is the API secret as generated by GDAX. Typically a 88 character value.
#' @param passphrase Mandatory character value. This is the passphrase as generated by GDAX. Typically a 11 character value.
#' @param product_id Optional character value for the currency pair. The default is \code{"BTC-USD"}. This param is case insensitive and must be one of the valid currency-pair. The list of valid currency-pairs can be fetched using \code{\link{public_info}}.
#' @param status Optional character value. Limit list of orders to either of `open`, `pending`, or `active` statuses. Passing `all` returns orders of all statuses.
#'
#' @return  Dataframe with all orders for a given status for that currency.
#'
#' @examples
#' \dontrun{
#' list_orders(api.key = your_key,
#' secret = your_api_secret,
#' passphrase = your_api_pass)
#'
#' list_orders(api.key=your_api_key,secret=your_secret,
#' passphrase=your_passphrase,
#' product_id="BTC-EUR",status="active")
#' }
#'
#' @export


# output tested on WIN. Macos pending
list_orders <- function(api.key,
                        secret,
                        passphrase,
                        product_id="BTC-USD",
                        status="open") {

	    #get url extension----
	    if (is.null(product_id) && is.null(status)) {
	          req.url = "/orders"
	    } else if(!is.null(product_id) && is.null(status)) {
	          product_id <- toupper(product_id)
	          req.url = paste0("/orders?product_id=", product_id)
	    } else if(is.null(product_id) && !is.null(status)) {
	          req.url = paste0("/orders?status=", status)
	    }else if(!is.null(product_id) && !is.null(status)) {
	          product_id <- toupper(product_id)
	          req.url = paste0("/orders?product_id=",
	                           product_id, "&status=", status)
	    }

	    #get method----
	    method <- "GET"

	        #fetch response----
	        response <- auth(method = method,
	                       req.url = req.url,
	                       api.key = api.key,
	                       secret = secret,
	                       passphrase = passphrase)

	        #transform----
	        response <- ldply(response, data.frame)


			    #return----
		return(response)
			  }


