#' Get List of All Orders the User
#'
#' @name open_orders
#'
#' @description This is an auth based function. User must have valid api keys generated by GDAX which must be passed as mandatory arguments. The function will return all open orders for all currencies. This is an extendion of \code{\link{holds}} & \code{\link{fills}}.
#'
#' @param api.key Mandatory character value. This is the API key as generated by GDAX. Typically a 32 character value.
#' @param secret Mandatory character value. This is the API secret as generated by GDAX. Typically a 88 character value.
#' @param passphrase Mandatory character value. This is the passphrase as generated by GDAX. Typically a 11 character value.
#'
#' @return  Dataframe with all orders and their status for that currency.
#'
#' @examples
#' \dontrun{
#' order_info(api.key = your_key, secret = your_api_secret, passphrase = your_api_pass)
#' }
#'
#' @export

# output tested on WIN. Macos pending
open_orders <- function(api.key,
                       secret,
                       passphrase) {
  #get url extension----
  req.url <-  paste0("/orders/")

  #define method----
  method <- "GET"

  #fetch response----
  response <- auth(
    method = method,
    req.url = req.url,
    api.key = api.key,
    secret = secret,
    passphrase = passphrase
  )

  #transform----
  response <- ldply(response, data.frame)


  #return----
  return(response)

}
