% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ee_Initialize.R
\name{ee_Authenticate}
\alias{ee_Authenticate}
\title{Prompts the user to authorize access to Earth Engine via OAuth2.}
\usage{
ee_Authenticate(
  user = NULL,
  earthengine = TRUE,
  drive = FALSE,
  gcs = FALSE,
  authorization_code = NULL,
  code_verifier = NULL,
  auth_mode = "notebook",
  scopes = NULL,
  quiet = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{user}{Character (optional). If is a character, the credentials are saved in
the dirpath: ~/.config/earthengine/$user. If is NULL, the credentials are stored
in ~/.config/earthengine.}

\item{earthengine}{Logical (optional). If TRUE, the EarthEngine credential
is cached in the path \code{~/.config/earthengine/}.}

\item{drive}{Logical (optional). If TRUE, the drive credential
is cached in the path \code{~/.config/earthengine/}.}

\item{gcs}{Logical (optional). If TRUE, the Google Cloud Storage
credential is cached in the path \code{~/.config/earthengine/}.}

\item{authorization_code}{An optional authorization code.}

\item{code_verifier}{PKCE verifier to prevent auth code stealing.}

\item{auth_mode}{The authentication mode. One of:
\describe{
\item{1. }{paste - send user to accounts.google.com to get a pastable token}
\item{2. }{notebook - send user to notebook authenticator page}
\item{3. }{gcloud - use gcloud to obtain credentials (will set appdefault)}
\item{4. }{appdefault - read from existing $GOOGLE_APPLICATION_CREDENTIALS file}
\item{5. }{None - a default mode is chosen based on your environment.}
}}

\item{scopes}{List of scopes to use for authentication. Defaults to
'https://www.googleapis.com/auth/earthengine' or
'https://www.googleapis.com/auth/devstorage.full_control'}

\item{quiet}{If TRUE, do not require interactive prompts and force --no-browser mode for gcloud.}

\item{verbose}{Logical. Suppress info messages.}
}
\description{
Prompts the user to authorize access to Earth Engine via OAuth2.
}
\examples{
\dontrun{
library(rgee)

# Simple init - Load just the Earth Engine credential
ee_Authenticate()

# At Server side
ee_Authenticate(quiet=TRUE)

}
}
