% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/open-set.R
\name{OpenSet}
\alias{OpenSet}
\title{Abstract Class for Open Set Manifolds}
\description{
Class for manifolds that are open sets of a vector space. In
this case, tangent vectors are identified with vectors of the ambient
space.
}
\examples{

## ------------------------------------------------
## Method `OpenSet$projection`
## ------------------------------------------------

if (reticulate::py_module_available("geomstats")) {
  spd3 <- SPDMatrix(n = 3)
  spd3$projection(diag(1, 3))
}
}
\seealso{
SPDMatrix
}
\author{
Nicolas Guigui and Nina Miolane
}
\keyword{internal}
\section{Super classes}{
\code{rgeomstats::PythonClass} -> \code{\link[rgeomstats:Manifold]{rgeomstats::Manifold}} -> \code{OpenSet}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{ambient_space}}{An object of class \code{\link{VectorSpace}} specifying the
ambient space.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-OpenSet-new}{\code{OpenSet$new()}}
\item \href{#method-OpenSet-projection}{\code{OpenSet$projection()}}
\item \href{#method-OpenSet-clone}{\code{OpenSet$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="PythonClass" data-id="get_python_class"><a href='../../rgeomstats/html/PythonClass.html#method-PythonClass-get_python_class'><code>rgeomstats::PythonClass$get_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="PythonClass" data-id="set_python_class"><a href='../../rgeomstats/html/PythonClass.html#method-PythonClass-set_python_class'><code>rgeomstats::PythonClass$set_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Manifold" data-id="belongs"><a href='../../rgeomstats/html/Manifold.html#method-Manifold-belongs'><code>rgeomstats::Manifold$belongs()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Manifold" data-id="is_tangent"><a href='../../rgeomstats/html/Manifold.html#method-Manifold-is_tangent'><code>rgeomstats::Manifold$is_tangent()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Manifold" data-id="random_point"><a href='../../rgeomstats/html/Manifold.html#method-Manifold-random_point'><code>rgeomstats::Manifold$random_point()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Manifold" data-id="random_tangent_vec"><a href='../../rgeomstats/html/Manifold.html#method-Manifold-random_tangent_vec'><code>rgeomstats::Manifold$random_tangent_vec()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Manifold" data-id="regularize"><a href='../../rgeomstats/html/Manifold.html#method-Manifold-regularize'><code>rgeomstats::Manifold$regularize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Manifold" data-id="set_metric"><a href='../../rgeomstats/html/Manifold.html#method-Manifold-set_metric'><code>rgeomstats::Manifold$set_metric()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Manifold" data-id="to_tangent"><a href='../../rgeomstats/html/Manifold.html#method-Manifold-to_tangent'><code>rgeomstats::Manifold$to_tangent()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OpenSet-new"></a>}}
\if{latex}{\out{\hypertarget{method-OpenSet-new}{}}}
\subsection{Method \code{new()}}{
The \code{\link{OpenSet}} class constructor.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OpenSet$new(dim, ambient_space, ..., py_cls = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dim}}{An integer value specifying the dimension of the manifold.}

\item{\code{ambient_space}}{An object of class \code{\link{VectorSpace}} specifying the
ambient space.}

\item{\code{...}}{Extra arguments to be passed to parent class constructors. See
\code{\link{Manifold}} class.}

\item{\code{py_cls}}{A Python object of class \code{OpenSet}. Defaults to \code{NULL} in
which case it is instantiated on the fly using the other input
arguments.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An object of class \code{\link{OpenSet}}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OpenSet-projection"></a>}}
\if{latex}{\out{\hypertarget{method-OpenSet-projection}{}}}
\subsection{Method \code{projection()}}{
Project a point in the ambient space onto the manifold.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OpenSet$projection(point)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{point}}{A numeric array of shape \eqn{[\dots \times
  \{\mathrm{dim}\}]} specifying one or more vectors in the ambient space
of the manifold.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A numeric array of the same shape storing the corresponding
projections onto the manifold.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{if (reticulate::py_module_available("geomstats")) {
  spd3 <- SPDMatrix(n = 3)
  spd3$projection(diag(1, 3))
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OpenSet-clone"></a>}}
\if{latex}{\out{\hypertarget{method-OpenSet-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OpenSet$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
