% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R, R/rgexf-package.R
\name{gexf-methods}
\alias{gexf-methods}
\alias{print.gexf}
\alias{summary.gexf}
\alias{export-gexf}
\title{S3 methods for \code{gexf} objects}
\usage{
\method{print}{gexf}(x, file = NA, replace = F, ...)

\method{summary}{gexf}(object, ...)
}
\arguments{
\item{x}{An \code{gexf} class object.}

\item{file}{String. Output path where to save the GEXF file.}

\item{replace}{Logical. If \code{file} exists, \code{TRUE} would replace the
file.}

\item{\dots}{Ignored}

\item{object}{An \code{gexf} class object.}
}
\value{
\item{list("print.gexf")}{ None (invisible \code{NULL}).}
\item{list("summary.gexf")}{ List containing some \code{gexf} object
statistics.}
}
\description{
Methods to print and summarize \code{gexf} class objects
}
\details{
\code{print.gexf} displays the graph (XML) in the console. If \code{file} is
not \code{NA}, a GEXF file will be exported to the indicated filepath.

\code{summay.gexf} prints summary statistics and information about the
graph.
}
\examples{

  if (interactive()) {
    # Data frame of nodes
    people <- data.frame(id=1:4, label=c("juan", "pedro", "matthew", "carlos"),
                     stringsAsFactors=F)
    
    # Data frame of edges
    relations <- data.frame(source=c(1,1,1,2,3,4,2,4,4), 
                        target=c(4,2,3,3,4,2,4,1,1))
    
    # Building gexf graph
    mygraph <- gexf(nodes=people, edges=relations)
    
    # Summary and pring
    summary(mygraph)
    
    write.gexf(mygraph, output="mygraph.gexf", replace=TRUE)
    
    # Plotting
    plot(mygraph)
    
  }
}
\seealso{
See also \code{\link{write.gexf}}, \code{\link{plot.gexf}}
}
\author{
George G. Vega Yon

Joshua B. Kunst
}
\keyword{methods}
