% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quiz-assignment.R
\name{create_quiz}
\alias{create_quiz}
\title{Create a quiz at a course}
\usage{
create_quiz(
  course_id = NULL,
  quiz_title = NULL,
  quiz_description = NULL,
  topic_id = NULL,
  coursework_title = "none",
  work_type = "ASSIGNMENT",
  due_date = NULL,
  assignment_description = ""
)
}
\arguments{
\item{course_id}{A course id where the quiz should be created}

\item{quiz_title}{A string indicating the title for the quiz}

\item{quiz_description}{A description for the quiz that will be made}

\item{topic_id}{Optional - a topic Id where the quiz will be posted}

\item{coursework_title}{a string that will be what the coursework title}

\item{work_type}{Currently only supported work type is ASSIGNMENT.}

\item{due_date}{A due date for this quiz, in year-month-day format}

\item{assignment_description}{The description that will be given for the assignment}
}
\description{
Create a quiz at a course
}
\examples{
\dontrun{

course_id <- get_course_list()$courses$id[1]
topic_id <- get_topic_list(course_id)$topic$topicId[1]

create_quiz(course_id,
  quiz_title = "new quiz", quiz_description = "This is a great quiz",
  topic_id = topic_id, due_date = "2025-12-1"
)
}
}
