% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hmc.R
\name{hmc}
\alias{hmc}
\title{Hamiltonian Monte Carlo}
\usage{
hmc(f, init, numit, L, eps, mass)
}
\arguments{
\item{f}{Minus log-density function of interest.}

\item{init}{Initial point for the algorithm.}

\item{numit}{Number of iterations.}

\item{L}{Leapfrog parameter: number of steps.}

\item{eps}{Leapfrog parameter: size of each step.}

\item{mass}{Mass vector.}
}
\value{
A list with the chain with the samples of interest, the values of
        the log-density calculated at each step and the acceptance rate.
}
\description{
Performs Hamiltonian Monte Carlo for a desired target function.
}
\examples{
f = function(x) -dnorm(x, 20, 10, log = TRUE)
hmc(f, 19, 1000, 16, 0.3, 0.1)

}
