% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tensor_fields.R
\name{g_ss}
\alias{g_ss}
\title{Schwarzschild metric tensor}
\usage{
g_ss(n, coords = c("t", "r", paste0("ph", 1:(n - 2))))
}
\arguments{
\item{n}{The dimension of the metric tensor.}

\item{coords}{A character vector of coordinate names. The length needs
to match the tensor dimensions.}
}
\value{
The covariant metric tensor as array imputed with coordinate names.
}
\description{
Provides the metric tensor of the Einstein equation's Schwarzschild solution
in Schwarzschild coordinates where the Schwarzschild radius \eqn{r_s} is set to 1.
\deqn{ds^2 = - \left(1-\frac{r_s}{r}\right) dt^2 + \left(1-\frac{r_s}{r}\right)^{-1} dr^r + r^2 d\Omega^2}
}
\details{
Note that Schwarzschild coordinates become singular at the Schwarzschild
radius (event horizon) \eqn{r=r_s=1} and at \eqn{r=0}.
}
\examples{
g_ss(4)
g_ss(4) \%_\% .(+i, +j)
}
\seealso{
Wikipedia: \href{https://en.wikipedia.org/wiki/Schwarzschild_metric}{Schwarzschild metric}

Other metric tensors: 
\code{\link{g_eucl_cart}()},
\code{\link{g_mink_cart}()},
\code{\link{g_sph}()},
\code{\link{metric_field}()}
}
\concept{metric tensors}
\concept{metric_tensors}
