% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tensor_ops.R
\name{kron}
\alias{kron}
\title{Kronecker product}
\usage{
kron(x, ...)
}
\arguments{
\item{x}{A labeled tensor object, created by \code{\link{\%_\%}} or \code{\link[=tensor]{tensor()}}.}

\item{...}{Any number of expressions (separated by a comma) of the form
\verb{.(<label1>, <label2>, ..., <labeln-1>) -> <labeln+1>}.}
}
\value{
A modified tensor object.
}
\description{
A Kronecker product is simply a tensor product whose underlying vector
space basis is relabeled. In the present context this is realized
by combining multiple index labels into one. The associated dimension
to the new label is then simply the product of the dimensions associated
to the old index labels respectively.
}
\examples{
a <- array(1:8, dim = c(2, 2, 2))
a \%_\% .(i, j, k) |> kron(.(i, j) -> l)
}
\seealso{
Wikipedia: \href{https://en.wikipedia.org/wiki/Kronecker_product}{Kronecker Product}

Other tensor operations: 
\code{\link{Ops.tensor}()},
\code{\link{asym}()},
\code{\link{l}()},
\code{\link{r}()},
\code{\link{subst}()},
\code{\link{sym}()}
}
\concept{arith}
\concept{tensor operations}
