% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/navigation.R
\name{ils}
\alias{ils}
\title{List iRODS Data Objects and Collections}
\usage{
ils(
  logical_path = ".",
  stat = FALSE,
  permissions = FALSE,
  metadata = FALSE,
  offset = numeric(1),
  limit = find_irods_file("max_number_of_rows_per_catalog_query"),
  recurse = FALSE,
  ticket = NULL,
  message = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{logical_path}{Path to the collection whose contents are to be listed.
By default this is the current working collection (see \code{\link[=ipwd]{ipwd()}}).}

\item{stat}{Whether stat information should be included. Defaults to \code{FALSE}.}

\item{permissions}{Whether access control information should be included.
Defaults to \code{FALSE}.}

\item{metadata}{Whether metadata information should be included. Defaults to
\code{FALSE}.}

\item{offset}{Number of records to skip for pagination. Deprecated.}

\item{limit}{Number of records to show per page.}

\item{recurse}{Recursively list. Defaults to \code{FALSE}.}

\item{ticket}{A valid iRODS ticket string. Defaults to \code{NULL}.}

\item{message}{Show message when empty collection. Default to \code{FALSE}.}

\item{verbose}{Whether information should be printed about the HTTP request
and response. Defaults to \code{FALSE}.}
}
\value{
Dataframe with logical paths and, if requested, additional
information.
}
\description{
List the contents of a collection, optionally with stat, metadata, and/or
access control information for each element in the collection.
}
\examples{
\dontshow{if (is_irods_demo_running()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
is_irods_demo_running()
\dontshow{
.old_config_dir <- Sys.getenv("R_USER_CONFIG_DIR")
Sys.setenv("R_USER_CONFIG_DIR" = tempdir())
}
# connect project to server
\Sexpr[stage=build, results=rd]{paste0("create_irods(\"", rirods:::.irods_host, "\")")}

# authenticate
iauth("rods", "rods")

# list home directory
ils()

# make collection
imkdir("some_collection")

# list a different directory
ils("/tempZone/home/rods/some_collection")

# show metadata
ils(metadata = TRUE)

# delete `some_collection`
irm("some_collection", force = TRUE, recursive = TRUE)
\dontshow{
Sys.setenv("R_USER_CONFIG_DIR" = .old_config_dir)
}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=ipwd]{ipwd()}} for finding the working collection,
\code{\link[=ipwd]{ipwd()}} for setting the working collection, and
\code{\link[=list.files]{list.files()}} for an R equivalent.
}
