% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metadata.R
\name{imeta}
\alias{imeta}
\title{Add or Remove Metadata}
\usage{
imeta(
  logical_path,
  entity_type = c("data_object", "collection", "user"),
  operations = list(),
  admin = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{logical_path}{Path to the data object or collection (or name of the user).}

\item{entity_type}{Type of item to add metadata to or remove it from.
Options are 'data_object', 'collection' and 'user'.  Deprecated.}

\item{operations}{List of named lists or \link{data.frame} representing operations.
The valid components of each of these lists or vectors are:
\itemize{
\item \code{operation}, with values 'add' or 'remove', depending on whether the AVU
should be added to or removed from the metadata of the item (required).
\item \code{attribute}, with the name of the AVU (required).
\item \code{value}, with the value of the AVU (required).
\item \code{units}, with the unit of the AVU (optional).
}}

\item{admin}{Whether to grant admin rights. Defaults to \code{FALSE}.}

\item{verbose}{Whether information should be printed about the HTTP request
and response. Defaults to \code{FALSE}.}
}
\value{
Invisibly, the HTTP response.
}
\description{
In iRODS, metadata is stored as attribute-value-units triples (AVUs), consisting
of an attribute name, an attribute value and an optional unit.
This function allows to chain several operations ('add' or 'remove') linked to
specific AVUs. Read more about metadata by looking at the iCommands
equivalent \code{imeta} in the \href{https://docs.irods.org/master/icommands/metadata/}{iRODS Docs}.
}
\examples{
\dontshow{if (is_irods_demo_running()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
is_irods_demo_running()

# demonstration server (requires Bash, Docker and Docker-compose)
# use_irods_demo()
\dontshow{
.old_config_dir <- Sys.getenv("R_USER_CONFIG_DIR")
Sys.setenv("R_USER_CONFIG_DIR" = tempdir())
}
# connect project to server
\Sexpr[stage=build, results=rd]{paste0("create_irods(\"", rirods:::.irods_host, "\")")}

# authentication
iauth("rods", "rods")

# some data
foo <- data.frame(x = c(1, 8, 9), y = c("x", "y", "z"))

# store
isaveRDS(foo, "foo.rds")

# check if file is stored
ils()

# add some metadata
imeta(
  "foo.rds",
   operations =
    list(
     list(operation = "add", attribute = "foo", value = "bar", units = "baz")
   )
)

# `operations` can contain multiple tags supplied as a `data.frame`
imeta(
  "foo.rds",
  operations = data.frame(
    operation = c("add", "add"),
    attribute = c("foo2", "foo3"),
    value = c("bar2", "bar3"),
    units = c("baz2", "baz3")
   )
 )

# or again as a list of lists
imeta(
  "foo.rds",
  operations = list(
    list(operation = "add", attribute = "foo4", value = "bar4", units = "baz4"),
    list(operation = "add", attribute = "foo5", value = "bar5", units = "baz5")
  )
)

# list of lists are useful as AVUs don't have to contain units
imeta(
  "foo.rds",
  operations = list(
    list(operation = "add", attribute = "foo6", value = "bar6"),
    list(operation = "add", attribute = "foo7", value = "bar7", units = "baz7")
  )
)

# check if file is stored with associated metadata
ils(metadata = TRUE)

# delete object
irm("foo.rds", force = TRUE)
\dontshow{
Sys.setenv("R_USER_CONFIG_DIR" = .old_config_dir)
}
\dontshow{\}) # examplesIf}
}
\references{
https://docs.irods.org/master/icommands/metadata/
}
\seealso{
\code{\link[=iquery]{iquery()}}
}
