% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-objects.R
\name{iput}
\alias{iput}
\alias{isaveRDS}
\title{Save Files and Objects in iRODS}
\usage{
iput(
  local_path,
  logical_path,
  offset = 0,
  count = 0,
  truncate = TRUE,
  verbose = FALSE,
  overwrite = FALSE,
  ticket = NULL
)

isaveRDS(
  x,
  logical_path,
  offset = 0,
  count = 0,
  truncate = TRUE,
  verbose = FALSE,
  overwrite = FALSE,
  ticket = NULL
)
}
\arguments{
\item{local_path}{Local path of file to be sent to iRODS.}

\item{logical_path}{Destination path in iRODS.}

\item{offset}{Offset in bytes into the data object. Deprecated.}

\item{count}{Maximum number of bytes to write. Deprecated.}

\item{truncate}{Whether to truncate the object when opening it. Deprecated.}

\item{verbose}{Whether to print information about the HTTP request and
response. Defaults to \code{FALSE}.}

\item{overwrite}{Whether the file in iRODS should be overwritten if it
exists. Defaults to \code{FALSE}.}

\item{ticket}{A valid iRODS ticket string. Defaults to \code{NULL}.}

\item{x}{R object to save in iRODS.}
}
\value{
(Invisibly) the HTTP response.
}
\description{
Store an object or file into iRODS. \code{\link[=iput]{iput()}} should be used to transfer
a file from the local storage to iRODS; \code{\link[=isaveRDS]{isaveRDS()}} saves an R object from
the current environment in iRODS in RDS format (see \code{\link[=saveRDS]{saveRDS()}}).
}
\examples{
\dontshow{if (is_irods_demo_running()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
is_irods_demo_running()
\dontshow{
.old_config_dir <- Sys.getenv("R_USER_CONFIG_DIR")
.old_wd <- setwd(tempdir())
Sys.setenv("R_USER_CONFIG_DIR" = tempdir())
}
# connect project to server
\Sexpr[stage=build, results=rd]{paste0("create_irods(\"", rirods:::.irods_host, "\")")}

# authenticate
iauth("rods", "rods")

# save the iris dataset as csv and send the file to iRODS
write.csv(iris, "iris.csv")
iput("iris.csv", "iris.csv")

# save with a different name
iput("iris.csv", "iris_in_irods.csv")
ils()

# send an R object to iRODS in RDS format
isaveRDS(iris, "iris_in_rds.rds")

# delete objects in iRODS
irm("iris_in_irods.csv", force = TRUE)
irm("iris_in_rds.rds", force = TRUE)
irm("iris.csv", force = TRUE)

\dontshow{
setwd(.old_wd)
Sys.setenv("R_USER_CONFIG_DIR" = .old_config_dir)
}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=iget]{iget()}} for obtaining files,
\code{\link[=ireadRDS]{ireadRDS()}} for obtaining R objects from iRODS,
\code{\link[=readRDS]{readRDS()}} for an R equivalent.
}
