% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/irods-print.R
\name{print.irods_df}
\alias{print.irods_df}
\title{Print Method for iRODS Data Frame Class.}
\usage{
\method{print}{irods_df}(
  x,
  ...,
  digits = NULL,
  quote = FALSE,
  right = TRUE,
  row.names = FALSE,
  max = NULL,
  message = TRUE
)
}
\arguments{
\item{x}{An object of class \code{irods_df}.}

\item{...}{optional arguments to \code{print} methods.}

\item{digits}{the minimum number of significant digits to be used: see
    \code{\link[base]{print.default}}.}

\item{quote}{logical, indicating whether or not entries should be
    printed with surrounding quotes.}

\item{right}{logical, indicating whether or not strings should be
    right-aligned.  The default is right-alignment.}

\item{row.names}{logical (or character vector), indicating whether (or
    what) row names should be printed.}

\item{max}{numeric or \code{NULL}, specifying the maximal number of
    entries to be printed.  By default, when \code{NULL},
    \code{\link[base]{getOption}("max.print")} used.}

\item{message}{Show message when empty collection. Default to \code{TRUE}.}
}
\value{
Invisibly return the class \code{irods_df} object.
}
\description{
Print Method for iRODS Data Frame Class.
}
\examples{
\dontshow{if (is_irods_demo_running()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
is_irods_demo_running()
\dontshow{
.old_config_dir <- Sys.getenv("R_USER_CONFIG_DIR")
Sys.setenv("R_USER_CONFIG_DIR" = tempdir())
}
# connect project to server
\Sexpr[stage=build, results=rd]{paste0("create_irods(\"", rirods:::.irods_host, "\")")}

# authenticate
iauth("rods", "rods")

# some data
foo <- data.frame(x = c(1, 8, 9), y = c("x", "y", "z"))

# store data in iRODS
isaveRDS(foo, "foo.rds")

# add some metadata
imeta(
  "foo.rds",
  operations =
   data.frame(operation = "add", attribute = "foo", value = "bar",
     units = "baz")
)

# iRODS Zone with metadata
irods_zone <- ils(metadata = TRUE)

# print (default no row.names)
print(irods_zone)

# with row.names
print(irods_zone, row.names = TRUE)

# delete object
irm("foo.rds", force = TRUE)
\dontshow{
Sys.setenv("R_USER_CONFIG_DIR" = .old_config_dir)
}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=print.data.frame]{print.data.frame()}}
}
