% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dependency_tree.R
\name{print_tree}
\alias{print_tree}
\title{Print a Package Dependency Tree}
\usage{
print_tree(tree, prefix = "", last = TRUE, show_version = TRUE)
}
\arguments{
\item{tree}{A nested list representing the package dependency tree, where each package has a `version` field and potentially sub-dependencies.}

\item{prefix}{A character string used for formatting tree branches (default: "").}

\item{last}{A logical value indicating if the current package is the last in the tree level (default: `TRUE`).}

\item{show_version}{A logical value indicating whether to display package versions if available (default: `TRUE`).}
}
\value{
Prints the dependency tree to the console.
}
\description{
This function prints a hierarchical representation of a package's dependencies, including version and base status
}
\examples{
\dontrun{
db <- list(
  stringr = list(
    version = "1.5.1",
    cli = list(version = "3.6.2", utils = "base"),
    glue = list(version = "1.7.0", methods = "base"),
    lifecycle = list(
      version = "1.0.4",
      cli = list(version = "3.6.2", utils = "base"),
      glue = list(version = "1.7.0", methods = "base"),
      rlang = list(version = "1.1.3", utils = "base")
    ),
    magrittr = list(version = "2.0.3"),
    rlang = list(version = "1.1.3", utils = "base"),
    stringi = list(version = "1.8.3", tools = "base", utils = "base", stats = "base"),
    vctrs = list(
      version = "0.6.5",
      cli = list(version = "3.6.2", utils = "base"),
      glue = list(version = "1.7.0", methods = "base"),
      lifecycle = list(version = "1.0.4"),
      rlang = list(version = "1.1.3", utils = "base")
    )
  )
)
print_tree(db)
}

}
