% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Cruncher.R
\encoding{UTF-8}
\name{cruncher}
\alias{cruncher}
\title{Run the 'JWSACruncher'}
\usage{
cruncher(
  workspace,
  cruncher_bin_directory = getOption("cruncher_bin_directory"),
  param_file_path,
  log_file = NULL,
  rename_multi_documents = FALSE,
  delete_existing_file = FALSE
)
}
\arguments{
\item{workspace}{Path to the workspace. By default a dialog box opens to choose the workspace.}

\item{cruncher_bin_directory}{Path to the "bin" directory of the 'JWSACruncher'. By default
the value of the option \code{"cruncher_bin_directory"} is used.}

\item{param_file_path}{Path to the parameter file of the 'JWSACruncher'. By default a .params file is search in the save directory of the workspace.}

\item{log_file}{Name of the log file of 'JWSACruncher'. By default the log isn't exported.}

\item{rename_multi_documents}{Boolean indicating whether to rename the folders
containing the outputs according to the names of the multi-documents of the workspace.
By default \code{rename_multi_documents = FALSE}: the names of the XML files of the multi-documents are used.}

\item{delete_existing_file}{Only used if \code{rename_multi_documents = TRUE}. Boolean indicating whether to
delete existing folders when renaming them. By default (\code{delete_existing_file = FALSE}) they are not deleted.}
}
\value{
The path to the workspace.
}
\description{
Function to run the 'JWSACruncher' on a workspace from a parameter file.
}
\examples{
\dontrun{
dir = tempdir()
# First create a parameter file
# here a file parameters.param is created in the directory dir
# with default parameters of 'JWSACruncher' v2
list2param_file(dir, default_param_file(v3 = FALSE))
# If the option "cruncher_bin_directory" is correctly defined:
cruncher("workspace.xml",
          param_file_path = file.path(dir, "parameters.param"))
}

}
\seealso{
Around the 'JWSACruncher': \code{\link[=cruncher_and_param]{cruncher_and_param()}}, \code{\link[=update_workspace]{update_workspace()}}.
To create the parameter file: \code{\link[=create_param_file]{create_param_file()}} and \code{\link[=list2param_file]{list2param_file()}}.
}
