% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rlcv.R
\name{rlcv}
\alias{rlcv}
\title{Robust likelihood cross validation bandwidth for univariate densities}
\usage{
rlcv(x.obs, x.new = NULL)
}
\arguments{
\item{x.obs}{Training (observed) data}

\item{x.new}{Evaluation data; default to x.obs}
}
\value{
fhat: density evaluated at x.new; h: bandwidth
}
\description{
Robust likelihood cross validation bandwidth for univariate densities
}
\examples{
x=rt(200,df=5)
x.new=seq(-5,5,length=100)
fit=rlcv(x.obs=x,x.new=x.new)
# Mean squared errors
f0=dt(x.new,df=5)
mean((f0-fit$fhat)^2)

matplot(x.new,cbind(f0,fit$fhat),type='l')
}
\references{
Wu, Ximing (2019), "Robust Likelihood Cross Validation for Kernel Density Estimation," Journal of Business and Economic Statistics, 37(4): 761-770.
}
\author{
Ximing Wu \email{xwu@tamu.edu}
}
