% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{Math.rle}
\alias{Math.rle}
\title{Mathematical functions for \code{\link{rle}} Objects}
\usage{
\method{Math}{rle}(x, ...)
}
\arguments{
\item{x}{An \code{\link{rle}} object.}

\item{...}{Additional arguments.}
}
\value{
In every supported case, the call should result in an
\code{\link{rle}} that would have resulted had the call been applied to the
original (uncompressed) vector, then compressed using
\code{\link{rle}}. (At no point in the calculation is the uncompressed
vector actually constructed, of course.)

By default, the functions do not merge adjacent
runs with the same value. This must be done explicitly with
\code{\link{compress.rle}}.
}
\description{
Mathematical functions that work independently elementwise on vectors described in \link{Math} are implemented for \code{\link{rle}} objects. See Details for list of exceptions.
}
\details{
Supported functions include all elements of the S3 \link{Math}
group excluding the "cumulative" ones, which are not supported at
this time and will raise an error. As of this writing, functions
supported include (from R help) \code{abs}, \code{sign}, \code{sqrt}, \code{floor},
\code{ceiling}, \code{trunc}, \code{round}, \code{signif}, \code{exp}, \code{log}, \code{expm1},
\code{log1p}, \code{cos}, \code{sin}, \code{tan}, \code{cospi}, \code{sinpi}, \code{tanpi}, \code{acos},
\code{asin}, \code{atan}, \code{cosh}, \code{sinh}, \code{tanh}, \code{acosh}, \code{asinh},
\code{atanh}, \code{lgamma}, \code{gamma}, \code{digamma}, and \code{trigamma}.

Functions \code{cumsum}, \code{cumprod}, \code{cummax}, and \code{cummin} are not
supported at this time and will raise an error.
}
\examples{

x <- rle(sample(runif(2), 10, c(.7,.3), replace=TRUE))

stopifnot(isTRUE(all.equal(sin(inverse.rle(x)),inverse.rle(sin(x)))))
stopifnot(inherits(try(cumprod(x)), "try-error"))
}
