% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/three_methods.r
\name{GR_est}
\alias{GR_est}
\title{GR Method}
\usage{
GR_est(x, y, I, sec, mat, school, section, rprpair = "hl-disp",
  verbose = FALSE)
}
\arguments{
\item{x}{Covariate matrix or data frame.}

\item{y}{Response matrix or data frame.}

\item{I}{Number of clusters}

\item{sec}{A vector of subcluster numbers in clusters.}

\item{mat}{A matrix of numbers of observations in subclusters.  Dimension is
Ixmax(number ofsubclusters). Each row indicates one cluster.}

\item{school}{A vector of clusters, nx1.}

\item{section}{A vector of subclusters, nx1.}

\item{rprpair}{By default, it uses "hl-disp" in the random prediction
procedure (RPP). Also, "med-mad" would be an alternative.}

\item{verbose}{Boolean indicating whether to print out messages from the
algorithm.}
}
\value{
\item{theta}{ Fixed effect estimates. }
  \item{ses}{ Standard error for the fixed esimates. }
  \item{sigma}{ Variances of cluster, subcluster, and residual. }
  \item{ehat}{ Raw error. }
  \item{ehats}{ Independence error from last weighted step. }
  \item{effect_sch}{ Cluster random error. }
  \item{effect_sec}{ Subcluster random error. }
  \item{effect_err}{ Epsilon error. }
}
\description{
Fits a model using the GR method
}
\examples{

# See rlme function

}
\author{
Yusuf Bilgic
}
\keyword{models}
