% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_rmc.R
\name{geom_rmc}
\alias{geom_rmc}
\title{geom_rmc: ggplot2 geom for simplified graphing}
\usage{
geom_rmc(rmc)
}
\arguments{
\item{rmc}{an object of class "rmc" generated from the \code{\link{rmcorr}} function.}
}
\description{
geom_rmc: ggplot2 geom for simplified graphing
}
\examples{
my.rmc <- rmcorr(participant = Subject, measure1 = PaCO2, measure2 = pH, 
                 dataset = bland1995)
                 
ggplot2::ggplot(bland1995, 
     ggplot2::aes(x = PaCO2, 
                  y = pH, 
                  color = factor(Subject))) +
     geom_rmc(my.rmc)
                  
                 
##manually:
ggplot2::ggplot(bland1995, 
     ggplot2::aes(x = PaCO2, 
                  y = pH, 
                  color = factor(Subject))) +
    ggplot2::geom_point(ggplot2::aes(colour = factor(Subject))) +
    ggplot2::geom_line(ggplot2::aes(y = my.rmc$model$fitted.values), 
                       linetype = 1)


##another example:
##new theme, remove legend, and custom color pal
ggplot2::ggplot(bland1995,
                ggplot2::aes(x = PaCO2,
                             y = pH,
                             color = factor(Subject))) +
   geom_rmc(my.rmc) +
   ggplot2::theme_minimal() +
   ggplot2::theme(legend.position="none") +
   ggplot2::scale_color_brewer(palette="Dark2")

}
\seealso{
\code{\link{rmcorr}, \link{plot.rmc} for base plotting}
}
